% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topconfects.R
\name{confects_plot_me2}
\alias{confects_plot_me2}
\title{Mean-expression vs effect size plot (version 2)}
\usage{
confects_plot_me2(confects, breaks = NULL, signed_colors = TRUE)
}
\arguments{
\item{confects}{A "Topconfects" class object, as returned from
\code{limma_confects}, \code{edger_confects}, or \code{deseq2_confects}.}

\item{breaks}{A vector of non-negative confect thresholds to color points with.
Chooses a sensible set of breaks if none are given.}

\item{signed_colors}{Should positive and negative confects be colored 
distinctly, red and blue.}
}
\value{
A ggplot2 object. Working non-interactively, you must print() this for it to
be displayed.
}
\description{
Like plotMD in limma, plots effect size against mean expression level.
Confect values are indicated using color.
This may be useful for assessing whether effects are
only being detected in highly expressed genes.
}
\examples{

library(NBPSeq)
library(edgeR)
library(limma)

data(arab)

# Extract experimental design from sample names
treat <- factor(substring(colnames(arab),1,4), levels=c("mock","hrcc"))
time <- factor(substring(colnames(arab),5,5))

# Keep genes with at least 3 samples having an RPM of more than 2
y <- DGEList(arab)
keep <- rowSums(cpm(y)>2) >= 3
y <- y[keep,,keep.lib.sizes=FALSE]
y <- calcNormFactors(y)

# Find top confident fold changes by topconfects-limma-voom method
design <- model.matrix(~time+treat)
voomed <- voom(y, design)
fit <- lmFit(voomed, design)
confects <- limma_confects(fit, "treathrcc")

# Plot confident effect size against mean expression
# (estimated effect size also shown as grey dots)
confects_plot_me2(confects)

}
