% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_function.R
\name{estimate3dExpressions}
\alias{estimate3dExpressions}
\title{Estimate 3d expressions}
\usage{
estimate3dExpressions(x, y, z, mask, query, numIter = 100, normalize = TRUE)
}
\arguments{
\item{x}{A data.frame object containing a simulated Tomo-seq data
for x-axis sections. The rows represent genes. The first column
contains gene IDs and the second and subsequent columns contain
gene expression levels in sections.}

\item{y}{A data.frame object containing a simulated Tomo-seq data for y-axis
sections. The rows represent genes. The first column contains gene IDs and
the second and subsequent columns contain gene expression levels in sections.}

\item{z}{A data.frame object containing a simulated Tomo-seq data for
z-axis sections. The rows represent genes. The first column
contains gene IDs and the second and subsequent columns contain
gene expression levels in sections.}

\item{mask}{A 3D array that represents if each boxel is included to sample.
You can make a mask using \code{masker}.}

\item{query}{Vector of gene IDs}

\item{numIter}{How many times iterate}

\item{normalize}{Whether to normalize so that total expression per sample
volume is equal between sections.}
}
\value{
tomoSeq object
}
\description{
Estimate 3d expressions
}
\examples{
data("testx", "testy", "testz", "mask")
estimate3dExpressions(
    testx,
    testy,
    testz,
    mask = mask,
    query = c("gene1"), 
    normalize = TRUE
)
}
