% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{runTSNE}
\alias{runTSNE}
\title{Perform TSNE}
\usage{
runTSNE(object, genes = NA, matrix = "auto", perplexity = NA, ...)
}
\arguments{
\item{object}{A \code{SummarizedExperiment} object.}

\item{genes}{\code{NA} or a vector of character. Perform TSNE on sections if it is \code{NA}, or on given genes if it is a vector of gene names.}

\item{matrix}{Character, must be one of \code{"auto"}, \code{"count"}, \code{"normalized"}, or \code{"scaled"}. If \code{"auto"}, normalized matrix is used for sections and scaled matrix is used for genes.}

\item{perplexity}{Numeric, perplexity parameter for Rtsne (default: 0.25 *(number of observations - 1)).}

\item{...}{Other parameters passed to \code{Rtsne}.}
}
\value{
A \code{SummarizedExperiment} object. The TSNE embeddings are saved in slot \code{meta} if TSNE is performed on sections, or saved in slot \code{gene_embedding} if TSNE is performed on genes.
}
\description{
Perform TSNE on sections or genes in a \code{SummarizedExperiment} object for dimensionality reduction.
}
\examples{
data(zh.data)
zh <- createTomo(zh.data)

# Perform TSNE on sections.
zh <- runTSNE(zh)

# Perform TSNE on sections with other perplexity.
zh <- runTSNE(zh, perplexity=10)

# Perform TSNE on some genes.
zh <- runTSNE(zh, genes=rownames(zh)[1:100])
}
\seealso{
\code{\link[Rtsne]{Rtsne}} for performing TSNE on a matrix.
}
