% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbml_as_list.R
\name{sbml_validate}
\alias{sbml_validate}
\title{Validate SBML schema}
\usage{
sbml_validate(sbml_file)
}
\arguments{
\item{sbml_file}{xml object, e.g. output of 'xml2::read_xml()'}
}
\value{
a boolean value with error details as attribute
}
\description{
This function returns result of schema validation for the SBML document inserted.
}
\details{
Validation is executed for SBML documents up to Level 2 Version 5, by using XML schemas provided in http://sbml.org/documents/specifications/. Otherwise returns error.
}
\examples{
filepath <- system.file("extdata", "MODEL1012080000.xml", package = "tidysbml")

xml_file <- xml2::read_xml(filepath)

sbml_validate(xml_file) ## returns a boolean value as result of validation in addition to attribute containing errors details
}
