% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot.R
\name{log10_reverse_trans}
\alias{log10_reverse_trans}
\title{Log10 reverse transformation for ggplot2}
\usage{
log10_reverse_trans()
}
\value{
A transformation object that can be used with ggplot2's scale functions
}
\description{
Creates a transformation that applies -log10(x) to data, useful for
visualizing p-values or other values where smaller values should be
displayed larger.
}
\examples{
\dontrun{
library(ggplot2)
# Example usage with p-values
ggplot(data, aes(x = pvalue)) +
  geom_histogram() +
  scale_x_continuous(trans = log10_reverse_trans())
}

}
