% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_methods.R
\name{append_samples}
\alias{append_samples}
\alias{append_samples.SummarizedExperiment}
\title{Append samples from multiple SummarizedExperiment objects}
\usage{
\method{append_samples}{SummarizedExperiment}(x, ..., .id = NULL)
}
\arguments{
\item{x}{First SummarizedExperiment object to combine}

\item{...}{Additional SummarizedExperiment objects to combine by samples}

\item{.id}{Object identifier (currently not used)}
}
\value{
A combined SummarizedExperiment object
}
\description{
Append samples from multiple SummarizedExperiment objects by column-binding them.
This function is equivalent to \code{cbind} but provides a tidyverse-like interface.
}
\examples{
data(se)
append_samples(se, se)

}
\references{
Hutchison, W.J., Keyes, T.J., The tidyomics Consortium. et al. The tidyomics ecosystem: enhancing omic data analyses. Nat Methods 21, 1166–1170 (2024). https://doi.org/10.1038/s41592-024-02299-2
}
