% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_methods.R
\name{distinct}
\alias{distinct}
\title{Keep distinct/unique rows}
\value{
An object of the same type as \code{.data}. The output has the following
properties:
\itemize{
\item Rows are a subset of the input but appear in the same order.
\item Columns are not modified if \code{...} is empty or \code{.keep_all} is \code{TRUE}.
Otherwise, \code{distinct()} first calls \code{mutate()} to create new columns.
\item Groups are not modified.
\item Data frame attributes are preserved.
}
}
\description{
Keep only unique/distinct rows from a data frame. This is similar
to \code{\link[=unique.data.frame]{unique.data.frame()}} but considerably faster.
}
\section{Methods}{


This function is a \strong{generic}, which means that packages can provide
implementations (methods) for other classes. See the documentation of
individual methods for extra arguments and differences in behaviour.

The following methods are currently available in loaded packages:
\Sexpr[stage=render,results=rd]{dplyr:::methods_rd("distinct")}.

}

\examples{
example(read10xVisium)
spe |>
   distinct(sample_id)
}
