% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_methods.R
\name{pull}
\alias{pull}
\alias{pull.SingleCellExperiment}
\title{Extract a single column}
\usage{
\method{pull}{SingleCellExperiment}(.data, var = -1, name = NULL, ...)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g. a tibble), or a
lazy data frame (e.g. from dbplyr or dtplyr). See \emph{Methods}, below, for
more details.}

\item{var}{A variable specified as:
\itemize{
\item a literal variable name
\item a positive integer, giving the position counting from the left
\item a negative integer, giving the position counting from the right.
}

The default returns the last column (on the assumption that's the
column you've created most recently).

This argument is taken by expression and supports
\link[rlang:topic-inject]{quasiquotation} (you can unquote column
names and column locations).}

\item{name}{An optional parameter that specifies the column to be used
as names for a named vector. Specified in a similar manner as \code{var}.}

\item{...}{For use by methods.}
}
\value{
A vector the same size as \code{.data}.
}
\description{
\code{pull()} is similar to \code{$}. It's mostly useful because it looks a little
nicer in pipes, it also works with remote data frames, and it can optionally
name the output.
}
\section{Methods}{


This function is a \strong{generic}, which means that packages can provide
implementations (methods) for other classes. See the documentation of
individual methods for extra arguments and differences in behaviour.

The following methods are currently available in loaded packages:
\Sexpr[stage=render,results=rd]{dplyr:::methods_rd("pull")}.

}

\examples{
data(pbmc_small)
pbmc_small |> pull(groups)
    
}
