% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{aggregate_cells}
\alias{aggregate_cells}
\alias{aggregate_cells,SingleCellExperiment-method}
\title{Aggregate cells}
\usage{
\S4method{aggregate_cells}{SingleCellExperiment}(
  .data,
  .sample = NULL,
  slot = "data",
  assays = NULL,
  aggregation_function = Matrix::rowSums,
  ...
)
}
\arguments{
\item{.data}{A tidySingleCellExperiment object}

\item{.sample}{A vector of variables by which cells are aggregated}

\item{slot}{The slot to which the function is applied}

\item{assays}{The assay to which the function is applied}

\item{aggregation_function}{The method of cell-feature value aggregation}

\item{...}{Used for future extendibility}
}
\value{
A tibble object
}
\description{
Combine cells into groups based on shared variables and aggregate feature counts.
}
\examples{
data(pbmc_small)
pbmc_small_pseudo_bulk <- pbmc_small |>
  aggregate_cells(c(groups, ident), assays="counts")

}
