% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terapadogBricks.R
\name{prepareGeneSets}
\alias{prepareGeneSets}
\title{This function retrieves KEGG-based gene sets, if 'gslist' is set to "KEGGRESTpathway".
oOtherwise, it uses the user-supplied list of gene sets, after
verifying that enough genes overlap with the provided expression data.
It also computes a weighting factor 'gf' to down-weight genes that appear
in many sets.}
\usage{
prepareGeneSets(
  esetm,
  gslist = "KEGGRESTpathway",
  organism = "hsa",
  gs.names = NULL,
  Nmin = 3,
  verbose = FALSE
)
}
\arguments{
\item{esetm}{A matrix of expression data, whose rownames are gene IDs.
Required for overlap checks with the sets.}

\item{gslist}{Either a user-supplied list of pathways,
or the default string "KEGGRESTpathway", indicating that KEGG gene sets
should be retrieved via the KEGGREST package.}

\item{organism}{A three-letter string giving the organism code for KEGG.
e.g. "hsa" for human. Defaults is "hsa".}

\item{gs.names}{Character vector with the names of the gene sets.
If specified, must have the same length as gslist.}

\item{Nmin}{The minimum size of gene sets to be included in the analysis.}

\item{verbose}{Logical. If true, shows number of gene sets being worked upon.}
}
\value{
A list with three elements: gslist, gs.names, gf.
gslist is the list of pathways/sets.
gs.names is the names of each gene pathway/set.
gf is the vector of gene weights, computed from how frequents genes are across sets.
}
\description{
This function retrieves KEGG-based gene sets, if 'gslist' is set to "KEGGRESTpathway".
oOtherwise, it uses the user-supplied list of gene sets, after
verifying that enough genes overlap with the provided expression data.
It also computes a weighting factor 'gf' to down-weight genes that appear
in many sets.
}
\examples{
  # Suppose 'esetm' is a matrix of counts, rownames are gene IDs.
  esetm <- matrix(
  data = c(10, 3, 25, 12, 8, 14, 7, 1, 5, 7, 2, 10, 11, 2, 27, 11, 8, 10, 6, 2, 4, 2),
  nrow =11,
  ncol = 2,
  dimnames = list (
  c("GeneA","GeneB","GeneC", "GeneD","GeneE", "GeneF", "GeneV", "GeneX","GeneY","GeneZ", "GeneW"),
  c("Sample1", "Sample2"))
  )
  # If we have our own sets in a list:
  mySets <- list(
    Path1 = c("GeneA","GeneB","GeneC"),
    Path2 = c("GeneX","GeneY","GeneZ", "GeneW"),
    Path3 = c("GeneA", "GeneZ", "GeneD", "GeneV"),
    Path4 = c("GeneA","GeneB","GeneY", "GeneE", "GeneF"),
    Path5 = c("GeneC", "GeneV")
  )
  gs.names <- c(Path1 = "Pathway_1",
  Path2 = "Pathway_2",
  Path3 = "Pathway_3",
  Path4 = "Pathway_4",
  Path5 = "Anne_PHathway")

  geneSets <- terapadog:::prepareGeneSets(esetm, gslist = mySets, gs.names = gs.names)

}
\keyword{internal}
