% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing_helpers.R
\name{check_integer_values}
\alias{check_integer_values}
\title{Check and Convert Dataframe Columns to Integers}
\usage{
check_integer_values(df)
}
\arguments{
\item{df}{A dataframe to be checked and potentially modified.}
}
\value{
A dataframe with numeric columns as integers.
}
\description{
This function checks whether each numeric column in the provided dataframe
contains only integer values. If a column contains floating-point numbers,
it rounds the values and converts them to integers.
}
\examples{
# Internal function, code cannot be run from here.
\dontrun{
rna_file <- system.file("extdata", "rna_counts.tsv",
package = "terapadog")
rna_df <- read.table(rna_file, header = TRUE, sep = "\t")
check_integer_values(rna_df)
}
}
\keyword{internal}
