% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tRNAscanImport-genome.R
\name{get.tRNAprecursor}
\alias{get.tRNAprecursor}
\title{Get tRNA precursor sequences}
\usage{
get.tRNAprecursor(
  input,
  genome,
  add.5prime = 50L,
  add.3prime = add.5prime,
  trim.intron = FALSE
)
}
\arguments{
\item{input}{a compatible \code{GRanges} object}

\item{genome}{a \code{\link[BSgenome:BSgenome-class]{BSgenome}} object, a 
\code{\link[Biostrings:XStringSet-class]{DNAStringSet}} object, a 
\code{\link[Rsamtools:FaFile-class]{FaFile}} object or a character vector 
with a single value referncing a file, which can be coerced to a 
\code{FaFile} object.}

\item{add.5prime, add.3prime}{the length of overhangs as a single integer 
value each. (default \code{add.5prime = 50L})}

\item{trim.intron}{\code{TRUE} or \code{FALSE}: Should intron sequences be
included in the precursor sequences? (default \code{trim.intron = FALSE})}
}
\value{
a \code{DNAStringSet} object, containing the precursor sequences.
}
\description{
\code{get.tRNAprecursor} retrieves tRNA precursor sequences from genomic
sequences. The length of 5'- and 3'-overhangs can be specifid individually.
The output is checked for validity against the tRNA sequences as reported by
tRNAscan.

The chromosomes names of tRNAscan input and genome sequences must be 
compatible.
}
\examples{
library(BSgenome.Scerevisiae.UCSC.sacCer3)
file <- system.file("extdata",
                    file = "yeast.tRNAscan",
                    package = "tRNAscanImport")
gr <- tRNAscanImport::import.tRNAscanAsGRanges(file)
genome <- getSeq(BSgenome.Scerevisiae.UCSC.sacCer3)
names(genome) <- c(names(genome)[-17],"chrmt")
get.tRNAprecursor(gr, genome)
# this produces an error since the seqnames do not match
\dontrun{
genome <- BSgenome.Scerevisiae.UCSC.sacCer3
names(genome) <- c(names(genome)[-17],"chrmt")
get.tRNAprecursor(gr, genome)
}
# ... but it can also be fixed
genome <- BSgenome.Scerevisiae.UCSC.sacCer3
seqnames(genome) <- c(seqnames(genome)[-17],"chrmt")
get.tRNAprecursor(gr, genome)
}
