\name{countRangeset}
\alias{countRangeset}
\title{
Read counting for several range sets
}
\description{
Convenience function to perform read counting iteratively for serveral 
range sets, e.g. peak range sets or feature types. Internally, 
the read counting is performed with the \code{summarizeOverlaps}
function from the \code{GenomicAlignments} package. The resulting count 
tables are directly saved to files.
}
\usage{
countRangeset(bfl, args, outfiles=NULL, format="tabular", ...)
}
\arguments{
  \item{bfl}{
    \code{BamFileList} object containing paths to one or more BAM files.
}
  \item{args}{
    An instance of \code{SYSargs} or \code{SYSargs2} constructed from a
    \code{targets} file where the first column (\code{targetsin(args)} or 
    \code{targets.as.df(targets(args))}) contains the paths to the tabular range 
    data files (e.g. peak ranges) used for counting. Another possibily is 
    \code{named character vector} with the paths to the tabular range data files 
    and the elements names should be the sampleID.
}
  \item{outfiles}{
    Default is \code{NULL}. When \code{args} is an object of \code{named 
    character vector} class, \code{outfile} argument is required. 
    \code{Named character vector} with the paths to the resulting count tables
    and the elements names should be the sampleID.
}
  \item{format}{
    Format of input range files. Currently, supported are \code{tabular} or 
    \code{bed}. If \code{tabular} is selected then the input range files need 
    to contain the proper column titles to coerce with \code{as(..., "GRanges")} 
    to \code{GRanges}  objects after importing them with \code{read.delim}. The 
    latter is the case for the peak files (\code{*peaks.xls}) generated by the 
    MACS2 software.
}
  \item{\dots}{
    Arguments to be passed on to internally used \code{summarizeOverlaps}
    function.
}
}
\value{
Named character vector containing the paths from \code{outpaths(args)} to the 
resulting count table files. 
}
\author{
Thomas Girke
}
\seealso{
\code{summarizeOverlaps}
}
\examples{
## Paths to BAM files
param <- system.file("extdata", "bowtieSE.param", package="systemPipeR")
targets <- system.file("extdata", "targets.txt", package="systemPipeR")
args_bam <- systemArgs(sysma=param, mytargets=targets)
bfl <- BamFileList(outpaths(args_bam), yieldSize=50000, index=character())

\dontrun{
##########################################
## Examples with \code{SYSargs2} object ##
##########################################
## Construct SYSargs2 object 
## SYSargs2 with paths to range data and count files
dir_path <- system.file("extdata/cwl/count_rangesets", package="systemPipeR")
args <- loadWF(targets = "targets_macs.txt", wf_file = "count_rangesets.cwl", 
    input_file = "count_rangesets.yml", dir_path = dir_path)
args <- renderWF(args, inputvars = c(FileName = "_FASTQ_PATH1_", SampleName = "_SampleName_"))

## Iterative read counting
countDFnames <- countRangeset(bfl, args, mode="Union", ignore.strand=TRUE)

##########################################
## Examples with \code{SYSargs} object ##
##########################################
## Construct SYSargs object 
## SYSargs with paths to range data and count files
args <- systemArgs(sysma="param/count_rangesets.param", mytargets="targets_macs.txt")

## Iterative read counting
countDFnames <- countRangeset(bfl, args, mode="Union", ignore.strand=TRUE)
writeTargetsout(x=args, file="targets_countDF.txt", overwrite=TRUE)
}
}
\keyword{ utilities }