% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_dose_response_model.R
\name{FindModelType}
\alias{FindModelType}
\title{Find the Type of Model Used for Fitting Dose Response Data}
\usage{
FindModelType(model)
}
\arguments{
\item{model}{An object of class 'drc'. It is generated by function
\code{\link{FitDoseResponse}}}
}
\value{
A character either "LL.4" or "L.4". It indicates the type of
model used for fitting dose response data.
}
\description{
\code{FindModelType} will extract the model type ("LL.4" or "L.4) eventually
used in funciton \code{\link{FitDoseResponse}}
}
\examples{
df <- data.frame(
  response = c(0, 29, 59, 60, 75, 90),
  dose = c(0.00, 9.7656, 39.0626, 156.25, 625, 2500)
)
model <- FitDoseResponse(df)
model.type <- FindModelType(model)
}
\author{
\itemize{
  \item Shuyu Zheng \email{shuyu.zheng@helsinki.fi}
  \item Jing Tang \email{jing.tang@helsinki.fi}
}
}
