% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rank_prts.R
\name{rank_prts}
\alias{rank_prts}
\title{Rank the surface proteins by differences in principal and alternative isoforms}
\usage{
rank_prts(counts, rank, n_prts)
}
\arguments{
\item{counts}{A data frame containing the overall length and individual lengths of
each section of the surface protein corresponding to a certain transcript.}

\item{rank}{String indicating which method to use to rank proteins in graphic
output. Options include "Length", "TM", and "Combo".}

\item{n_prts}{Integer value indicating the number of genes that should be
displayed on the graphical output. Default value is 20.}
}
\value{
A data frame containing the overall length and individual lengths of
each section of the surface protein corresponding to a certain transcript
ranked by how different the primary and alternative transcripts are
functionally.
}
\description{
This function creates a data frame containing the primary and alternative
transcripts of each gene ranked by how different the resultant surface proteins
are. Transcripts can be ranked by length, number of transmembrane domains,
or a combo metric that multiplied the difference in length by the number of
transmembrane domains and ranks accordingly. This function can also be set
to restrict the number of genes that are returned to the user to show only
the most significant gene transcripts.
}
