% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_prts.R
\name{get_prts}
\alias{get_prts}
\title{Create fasta file containing amino acid sequences based on IDs}
\usage{
get_prts(aa_trans, temp = FALSE)
}
\arguments{
\item{aa_trans}{A data frame containing the gene names, transcript IDs, APPRIS
annotations, UniProt Swissprot IDs, UniProt Swissprot isoform IDs, and
UniProt TREMBL IDs for all transcripts.}

\item{temp}{Boolean indicating if the fasta file should be deleted after the
function finishes running or not. Recommended to always be set to FALSE.}
}
\value{
A data frame containing the gene names, transcript IDs, APPRIS
annotations, UniProt IDs, and protein sequences for each transcript.
}
\description{
This function creates a fasta file with the transcript ID followed by the
amino acid sequence for all given alternative transcripts
and associated primary transcripts. The file is organized so that all
transcripts from a gene are next to each other. The function also returns
a final table containing the gene names, transcript IDs, APPRIS annotations,
and amino acid sequences for each transcript
}
\note{
This function also creates a fasta file containing the transcript IDs
and associated amino acid sequences in the root directory.
}
