% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_aas.R
\name{get_aas}
\alias{get_aas}
\title{Create fasta file containing amino acid sequences based on user sequences}
\usage{
get_aas(final_pairs, temp = FALSE)
}
\arguments{
\item{final_pairs}{A data frame containing gene names, transcript IDs, amino
acid sequences, and APPRIS annotations for all inputted data and its
corresponding primary transcripts.}

\item{temp}{Boolean indicating if the fasta file should be deleted after the
function finishes running or not. Recommended to always be set to FALSE.}
}
\value{
A data frame containing the gene names, transcript IDs, APPRIS
annotations, and protein sequences for each transcript.
}
\description{
This function creates a fasta file with the transcript ID followed by the
amino acid sequence for all inputted and associated primary transcripts. The
file is organized so that all transcripts from a gene are next to each other.
The function also returns a final table containing the gene names, transcript
IDs, APPRIS annotations, and amino acid sequences for each transcript
}
\note{
This function also creates a fasta file containing the transcript IDs
and associated amino acid sequences in the root directory.
}
