% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_signature.R
\name{predict_signature}
\alias{predict_signature}
\title{Function to predict using SuperSig object}
\usage{
predict_signature(object, newdata, factor)
}
\arguments{
\item{object}{an object of class \code{SuperSig}}

\item{newdata}{a data frame of mutations containing columns for
\code{sample_id}, \code{age}, \code{IndVar}, and the 96 trinucleotide
mutations (see vignette for details)}

\item{factor}{the factor/exposure (e.g. "age", "smoking")}
}
\value{
\code{predict_signature} returns the original data frame with 
additional columns for the feature counts and classification score
}
\description{
Using a generated SuperSig, predict on a new dataset and return 
predicted probabilities for each observation.
}
\examples{

head(example_dt) # use example data from package
input_dt <- make_matrix(example_dt) # convert to correct format
input_dt$IndVar <- c(1, 1, 1, 0, 0) # add IndVar column
out <- get_signature(data = input_dt, factor = "Age") # get SuperSig
newdata <- predict_signature(out, newdata = input_dt, factor = "age")
suppressPackageStartupMessages({library(dplyr)})
head(newdata \%>\% select(score))

}
