% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DatasetExperiment_class.R
\name{DatasetExperiment}
\alias{DatasetExperiment}
\alias{$,DatasetExperiment-method}
\alias{$<-,DatasetExperiment-method}
\title{DatasetExperiment class}
\usage{
DatasetExperiment(
  data = data.frame(),
  sample_meta = data.frame(),
  variable_meta = data.frame(),
  ...
)

\S4method{$}{DatasetExperiment}(x, name)

\S4method{$}{DatasetExperiment}(x, name) <- value
}
\arguments{
\item{data}{A data frame with samples in rows and features in columns}

\item{sample_meta}{A data frame with samples in rows and meta data in columns}

\item{variable_meta}{A data frame with features in rows and meta data in columns}

\item{...}{named slot values to pass through to struct_class}

\item{x}{A DatasetExperiment object}

\item{name}{DatasetExperiment slot to get/set}

\item{value}{the value to assign to the named slot}
}
\value{
DatasetExperiment
}
\description{
An object for holding raw data and associated meta data
}
\details{
The DatasetExperiment object is an extension of the SummarizedExperiment object 
from the SummarizedExperiment package (found on Bioconductor). 
It incorporates the basic functionality of struct objects, containing fields such as 
Description, Name and Type with features of SummarizedExperiment such as subsetting.

There are some important differences between DatasetExperiment and SummarizedExperiment:
\itemize{
\item In DatasetExperiment data is stored as Samples (rows) x Features (columns)
\item DatasetExperiment currently only supports a single assay
\item length(DatasetExperiment) returns the number of samples
}
}
\section{Slots}{

\describe{
\item{\code{name}}{Name of the dataset}

\item{\code{description}}{Brief description of the dataset}

\item{\code{type}}{The type of dataset e.g. single_block}
}}

