% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/ontology_term_class.R,
%   R/struct_class.R
\name{ontology}
\alias{ontology}
\alias{ontology_term}
\alias{ontology_list}
\alias{[,ontology_list,ANY,ANY,ANY-method}
\alias{[<-,ontology_list,ANY,ANY,ANY-method}
\alias{length,ontology_list-method}
\alias{ontology,struct_class-method}
\title{Ontology for an object}
\usage{
ontology(obj, cache = NULL)

ontology_term(
  id,
  ontology = character(),
  label = character(),
  description = character(),
  iri = character(),
  rols = TRUE
)

ontology_list(terms = list())

\S4method{[}{ontology_list,ANY,ANY,ANY}(x, i)

\S4method{[}{ontology_list,ANY,ANY,ANY}(x, i) <- value

\S4method{length}{ontology_list}(x)

\S4method{ontology}{struct_class}(obj, cache = NULL)
}
\arguments{
\item{obj}{a struct object}

\item{cache}{a named list of ontology_terms for offline use. Terms from the cache are search
based on the name of the list items matching the ontology id. If cache=NULL then the OLS API is used to lookup terms.}

\item{id}{(character) The ontology term id e.g. 'STATO:0000555'}

\item{ontology}{(character) The ontology the term is a member of e.g. 'stato'}

\item{label}{(character) The label for the ontology term}

\item{description}{(character) The description of the term}

\item{iri}{(character) The Internationalized Resource Identifier for the term}

\item{rols}{(logical) TRUE or FALSE to query the Ontology Lookup Service for
missing label, description or iri if not provided as input.
Default rols = TRUE}

\item{terms}{A list of ontology_term objects.}

\item{x}{the list}

\item{i}{The list item index}

\item{value}{an ontology_term() object}
}
\value{
model at the given index in the sequence

model sequence with the model at index i replaced

the number of models in the sequence
}
\description{
All \code{struct} objects have an "ontology" slot, which is a list of
ontology items for the object. The \code{ontology} method gathers
ontology items from an object and all \code{struct} objects that it inherits to generate
a complete list.

A base class in the \pkg{struct} package. Stores
ontology information e.g. term, description, id etc for struct objects
and provides methods for populating these fields using the
`rols` package.

A base class in the \pkg{struct} package. Stores
multiple `ontology_term` objects.
}
\examples{
M = example_model()
ontology(M,cache=NULL)
\dontrun{
OT = ontology_term(id='STATO:0000555')
}
\dontrun{
OT = ontology_list(terms=list(
    ontology_term(ontology='obi',id =  'OBI:0200051'),
    ontology_term(ontology='stato',id ='STATO:0000555')
)
}
\dontrun{
OL = ontology_list('STATO:0000555')
OL[1]
}

\dontrun{
OL = ontology_list('STATO:0000555')
OL[1] = ontology_term('STATO:0000302')
}
\dontrun{
OL = ontology_list()
length(OL) # 0
}
}
