% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permute_sample_order_class.R
\name{permute_sample_order}
\alias{permute_sample_order}
\title{Permute Sample Order}
\usage{
permute_sample_order(number_of_permutations = 10, ...)
}
\arguments{
\item{number_of_permutations}{(numeric, integer) The number of times the sample order is permuted. The default is \code{10}.\cr}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A  \code{permute_sample_order} object with the following \code{output} slots:
\tabular{ll}{
\code{results} \tab          (data.frame)  \cr
\code{metric} \tab          (data.frame)  \cr
\code{metric.train} \tab          (numeric)  \cr
}
}
\description{
The order of samples in the data matrix is randomly permuted. The relationship between the samples and the sample meta data is maintained.
}
\section{Inheritance}{

A \code{permute_sample_order} object inherits the following \code{struct} classes: \cr\cr
\verb{[permute_sample_order]} >> \verb{[resampler]} >> \verb{[iterator]} >> \verb{[struct_class]}
}

\examples{
M = permute_sample_order(
      number_of_permutations = 100)

C = permute_sample_order()
}
