% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mv_sample_filter_class.R
\name{mv_sample_filter}
\alias{mv_sample_filter}
\title{Missing value sample filter}
\usage{
mv_sample_filter(mv_threshold = 20, ...)
}
\arguments{
\item{mv_threshold}{(numeric) The maximum percentage of features with missing values in a sample. The default is \code{20}.\cr}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A  \code{mv_sample_filter} object with the following \code{output} slots:
\tabular{ll}{
\code{filtered} \tab          (DatasetExperiment) A DatasetExperiment object containing the filtered data. \cr
\code{flags} \tab          (data.frame) A flag indicating whether the sample was rejected. 0 = rejected. \cr
\code{percent_missing} \tab          (data.frame) \% missing values for each sample. \cr
}
}
\description{
Removes samples where the percent number of missing values exceeds a threshold.
}
\details{
This object makes use of functionality from the following packages:\itemize{  \item{\code{pmp}}}
}
\section{Inheritance}{

A \code{mv_sample_filter} object inherits the following \code{struct} classes: \cr\cr
\verb{[mv_sample_filter]} >> \verb{[model]} >> \verb{[struct_class]}
}

\examples{
M = mv_sample_filter(
      mv_threshold = 20)

C = mv_sample_filter()
}
\references{
Jankevics A, Lloyd GR, Weber RJM (????). \emph{pmp: Peak Matrix Processing
and signal batch correction for metabolomics datasets}. R package
version 1.15.1.
}
