% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mv_feature_filter_class.R
\name{mv_feature_filter}
\alias{mv_feature_filter}
\title{Filter features by missing values}
\usage{
mv_feature_filter(
  threshold = 20,
  qc_label = "QC",
  method = "QC",
  factor_name,
  ...
)
}
\arguments{
\item{threshold}{(numeric) The minimum percentage of non-missing values. The default is \code{20}.\cr}

\item{qc_label}{(character) The label used to identify QC/group samples when using the "QC" (within a named group) filtering method. The default is \code{"QC"}.}

\item{method}{(character) Filtering method. Allowed values are limited to the following: \itemize{ \item{\code{"within_all"}: Features are removed if the threshold for non-missing values is not met for all groups.}\item{\code{"within_one"}: Features are removed if the threshold for non-missing values is not met for any group.}\item{\code{"QC"}: Features are removed if the threshold for non-missing values is not met for the named group.}\item{\code{"across"}: The filter is applied ignoring sample group.}} The default is \code{"QC"}.}

\item{factor_name}{(character) The name of a sample-meta column to use.}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A  \code{mv_feature_filter} object with the following \code{output} slots:
\tabular{ll}{
\code{filtered} \tab          (DatasetExperiment) A DatasetExperiment object containing the filtered data. \cr
\code{flags} \tab          (data.frame) \% missing values and a flag indicating whether the sample was rejected. 0 = rejected. \cr
}
}
\description{
Removes features where the percentage of non-missing values falls below a threshold.
}
\details{
This object makes use of functionality from the following packages:\itemize{  \item{\code{pmp}}}
}
\section{Inheritance}{

A \code{mv_feature_filter} object inherits the following \code{struct} classes: \cr\cr
\verb{[mv_feature_filter]} >> \verb{[model]} >> \verb{[struct_class]}
}

\examples{
M = mv_feature_filter(
      threshold = 20,
      qc_label = "QC",
      method = "QC",
      factor_name = "V1")

D = iris_DatasetExperiment()
M = mv_feature_filter(factor_name='Species',qc_label='versicolor')
M = model_apply(M,D)
}
\references{
Jankevics A, Lloyd GR, Weber RJM (????). \emph{pmp: Peak Matrix Processing
and signal batch correction for metabolomics datasets}. R package
version 1.15.1.
}
