% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glog_class.R
\name{glog_transform}
\alias{glog_transform}
\title{Generalised logarithmic transform}
\usage{
glog_transform(qc_label = "QC", factor_name, lambda = NULL, ...)
}
\arguments{
\item{qc_label}{(character) The label used to identify QC samples. The default is \code{"QC"}.}

\item{factor_name}{(character) The name of a sample-meta column to use.}

\item{lambda}{(numeric, NULL) The value of lambda to use. If NULL then the pmp package will be used to determine an "optimal" value for lambda. The default is \code{NULL}.}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A  \code{glog_transform} object with the following \code{output} slots:
\tabular{ll}{
\code{transformed} \tab          (DatasetExperiment) A DatasetExperiment object containing the glog transformed data. \cr
\code{error_flag} \tab          (logical) A logical indicating whether the glog optimisation for lambda was successful. If not then PMP returns a default value for lambda. \cr
}
}
\description{
The generalised logarithm (glog) transformation applies a log transformation while applying an offset to account for technical variation.
}
\details{
This object makes use of functionality from the following packages:\itemize{  \item{\code{pmp}}}
}
\section{Inheritance}{

A \code{glog_transform} object inherits the following \code{struct} classes: \cr\cr
\verb{[glog_transform]} >> \verb{[model]} >> \verb{[struct_class]}
}

\examples{
M = glog_transform(
      qc_label = "QC",
      factor_name = "V1",
      lambda = NULL)

D = iris_DatasetExperiment()
M = glog_transform(qc_label='versicolor',factor_name='Species')
M = model_apply(M,D)
}
\references{
Jankevics A, Lloyd GR, Weber RJM (????). \emph{pmp: Peak Matrix Processing
and signal batch correction for metabolomics datasets}. R package
version 1.15.1.

Durbin B, Hardin J, Hawkins D, Rocke D (2002). "A variance-stabilizing
transformation for gene-expression microarray data." \emph{Bioinformatics},
\emph{18}(Suppl 1), S105-S110.

Parsons HM, Ludwig C, Gunther UL, Viant MR (2007). "Improved
classification accuracy in 1- and ', '2-dimensional NMR metabolomics
data using the variance ', 'stabilising generalised logarithm
transformation." \emph{Bioinformatics}, \emph{8}(1), 234.
}
