% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corr_coef_class.R
\name{corr_coef}
\alias{corr_coef}
\title{Correlation coefficient}
\usage{
corr_coef(alpha = 0.05, mtc = "fdr", factor_names, method = "spearman", ...)
}
\arguments{
\item{alpha}{(numeric) The p-value cutoff for determining significance. The default is \code{0.05}.\cr}

\item{mtc}{(character) Multiple test correction method. Allowed values are limited to the following: \itemize{ \item{\code{"bonferroni"}: Bonferroni correction in which the p-values are multiplied by the number of comparisons.}\item{\code{"fdr"}: Benjamini and Hochberg False Discovery Rate correction.}\item{\code{"none"}: No correction.}} The default is \code{"fdr"}.}

\item{factor_names}{(character) The name of sample meta column(s) to use.}

\item{method}{(character) Type of correlation. Allowed values are limited to the following: \itemize{ \item{\code{"kendall"}: Kendall's tau is computed.}\item{\code{"pearson"}: Pearson product moment correlation is computed.}\item{\code{"spearman"}: Spearman's rho statistic is computed.}} The default is \code{"spearman"}.}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A  \code{corr_coef} object with the following \code{output} slots:
\tabular{ll}{
\code{coeff} \tab          (data.frame) The value of the calculate statistics which is converted to a p-value when compared to a t-distribution. \cr
\code{p_value} \tab          (data.frame) The probability of observing the calculated statistic if the null hypothesis is true. \cr
\code{significant} \tab          (data.frame) True/False indicating whether the p-value computed for each variable is less than the threshold. \cr
}
}
\description{
The correlation between features and a set of continuous factor are calculated. Multiple-test corrected p-values are used to indicate whether the computed coefficients may have occurred by chance.
}
\details{
This object makes use of functionality from the following packages:\itemize{  \item{\code{stats}}}
}
\section{Inheritance}{

A \code{corr_coef} object inherits the following \code{struct} classes: \cr\cr
\verb{[corr_coef]} >> \verb{[model]} >> \verb{[struct_class]}
}

\examples{
M = corr_coef(
      alpha = 0.05,
      mtc = "fdr",
      factor_names = "V1",
      method = "spearman")

D = MTBLS79_DatasetExperiment(filtered=TRUE)

# subset for this example
D = D[,1:10]

# convert to numeric for this example
D$sample_meta$sample_order=as.numeric(D$sample_meta$run_order)
D$sample_meta$sample_rep=as.numeric(D$sample_meta$Sample_Rep)

M = corr_coef(factor_names=c('sample_order','sample_rep'))
M = model_apply(M,D)
}
\references{
R Core Team (2024). \emph{R: A Language and Environment for Statistical
Computing}. R Foundation for Statistical Computing, Vienna, Austria.
\url{https://www.R-project.org/}.
}
