% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standR-package.R
\docType{package}
\name{standR-package}
\alias{standR-package}
\alias{standR}
\title{Tools for analyzing NanoString's GeoMX spatial transcriptomics data}
\description{
\code{standR} implements a series of functions to facilitate inspection,
analysis and visualization of the NanoString's GeoMX DSP datasets. \code{standR}
takes the either the csv files from the Nanostring or DGEList object as
input, allowing for multiple methods to be analyzed together.
}
\details{
\code{standR} represents the GeoMX DSP data as SpatialExperiment objects, which can
easily be integrated with a wide variety of Bioconductor packages.\code{standR}
generates various plots, such as QC distribution plots, dimension reduction
plots and RLE plots, for quality control of genes and region of interest
(ROI) samples. Multiple normalization and batch correction methods are also
provided in the package as well, with the ability to compute statistics for
assessing the normalization/batch correction results.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/DavisLaboratory/standR}
  \item Report bugs at \url{https://github.com/DavisLaboratory/standR/issues}
}

}
\author{
Ning Liu \email{liu.n@wehi.edu.au}
}
\keyword{internal}
