% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcaOtherPlotting.R
\name{plotPairPCA}
\alias{plotPairPCA}
\title{Plot pair-wise PCA plots for multiple dimensions}
\usage{
plotPairPCA(
  spe_object,
  n_dimension = 3,
  precomputed = NULL,
  assay = 2,
  title = NA,
  title.size = 14,
  rmduplabs = FALSE,
  flipcoord = FALSE,
  legend.pos = "top",
  ...
)
}
\arguments{
\item{spe_object}{A SpatialExperiment object.}

\item{n_dimension}{The top n dimensions to be plotted}

\item{precomputed}{a dimensional reduction results from \code{stats::prcomp}.
result in \code{reducedDims(object)} to plot. Default is NULL,
we will compute for you.}

\item{assay}{a numeric or character, specifying the assay to use (for
\code{SummarizedExperiment} and its derivative classes).}

\item{title}{Character vector, title to put at the top.}

\item{title.size}{Numeric vector, size of the title.}

\item{rmduplabs}{Remove duplicated labels from the plot. FALSE by default.}

\item{flipcoord}{Flip the xy coordinates. FALSE by default.}

\item{legend.pos}{Position of the legend. top by default.}

\item{...}{aesthetic mappings to pass to \code{ggplot2::aes()}.}
}
\value{
A ggplot object.
}
\description{
Plot pair-wise PCA plots for multiple dimensions
}
\examples{
data("dkd_spe_subset")
plotPairPCA(dkd_spe_subset)
}
