% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batchCorrection.R
\name{findBestK}
\alias{findBestK}
\title{Testing multiple K for RUV4 batch correction to find the best K.}
\usage{
findBestK(
  spe,
  maxK = 10,
  factor_of_int,
  factor_batch,
  NCGs,
  point_size = 3,
  line_col = "black",
  point_col = "black",
  text_size = 13
)
}
\arguments{
\item{spe}{A Spatial Experiment object.}

\item{maxK}{Integer. The max k to test, will test k from 1 to maxK, by default is 10.}

\item{factor_of_int}{Column name(s) to indicate the factors of interest. This is required for the RUV4 method.}

\item{factor_batch}{Column name to indicate the batch.}

\item{NCGs}{Negative control genes. This is required for the RUV4 method.}

\item{point_size}{Numeric. Plotting parameter.}

\item{line_col}{Character. Plotting parameter.}

\item{point_col}{Character. Plotting parameter.}

\item{text_size}{Numeric. Plotting parameter.}
}
\value{
A ggplot object.
}
\description{
Testing multiple K for RUV4 batch correction to find the best K.
}
\examples{
data("dkd_spe_subset")
spe <- findNCGs(dkd_spe_subset, top_n = 100)
findBestK(spe,
  factor_of_int = c("disease_status"),
  factor_batch = "SlideName", NCGs = S4Vectors::metadata(spe)$NCGs
)

}
