% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addQCstat.R
\name{addPerROIQC}
\alias{addPerROIQC}
\title{Add QC statistics to the Spatial Experiment object}
\usage{
addPerROIQC(
  spe_object,
  sample_fraction = 0.9,
  rm_genes = TRUE,
  min_count = 5,
  design = NULL
)
}
\arguments{
\item{spe_object}{A SpatialExperiment object}

\item{sample_fraction}{Double. Genes with low count in more than this threshold of the samples will be removed. Default is 0.9}

\item{rm_genes}{Logical. Decide whether genes with low count in more than sample_fraction of the samples are removed from the dataset. Default is TRUE.}

\item{min_count}{Integer. Minimum read count to calculate count threshold. Default is 5.}

\item{design}{Generate using \code{model.matrix}, if this is specify, \code{edgeR::filterByExpr} will be used to filter genes.}
}
\value{
A SpatialExperiment object
}
\description{
Add QC statistics to the Spatial Experiment object
}
\examples{
data("dkd_spe_subset")
spe_filtered <- addPerROIQC(dkd_spe_subset)
spe_filtered

}
