% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/accessors.R
\docType{methods}
\name{getAdjustedPValues}
\alias{getAdjustedPValues}
\alias{getAdjustedPValues}
\alias{getAdjustedPValues,stageR}
\alias{getAdjustedPValues,stageRTx}
\alias{getAdjustedPValues,stageRTx,logical,logical-method}
\title{Retrieve the stage-wise adjusted p-values.}
\usage{
getAdjustedPValues(object, onlySignificantGenes, order, ...)

\S4method{getAdjustedPValues}{stageR,logical,logical}(object,
  onlySignificantGenes, order, ...)

\S4method{getAdjustedPValues}{stageRTx,logical,logical}(object,
  onlySignificantGenes, order, ...)
}
\arguments{
\item{object}{an object of the \code{\link{stageRClass}} class.}

\item{onlySignificantGenes}{logical. If FALSE (default), all genes are returned. If TRUE, only the genes significant for the screening hypothesis are returned.}

\item{order}{logical. If TRUE (default), the returned matrix of adjusted p-values are ordered based on the screening hypothesis adjusted p-value.}

\item{...}{Other arguments passed to .getAdjustedP or .getAdjustedPTx}
}
\value{
For complex DGE experiments (stageR object), a matrix of adjusted p-values where every row corresponds to a gene, and every column corresponds to a contrast. The first column will be the BH FDR adjusted p-value from the screening step.
For transcript-level experiments (stageRTx object), a matrix of adjusted p-values where every row corresponds to a transcript.
}
\description{
This functions returns the stage-wise adjusted p-values for an object from the  \code{\link{stageRClass}} class. Note, that the p-values should have been adjusted with the \code{\link{stageWiseAdjustment,stageR,character,numeric-method}} function prior to calling this function.
}
\details{
The function returns FDR adjusted p-values for the screening hypothesis and stage-wise adjusted p-values for the confirmation hypothesis p-values. For features that were not significant in the screening hypothesis, the confirmation stage adjusted p-values are set to \code{NA}.
The adjusted p-values in the output of \code{getAdjustedPValues} can directly be compared to alpha, the OFDR level specified in \code{stageWiseAdjustment}, to flag significant features.
}
\section{Methods (by class)}{
\itemize{
\item \code{object = stageRTx,onlySignificantGenes = logical,order = logical}: Retrieve the stage-wise adjusted p-values.
}}

\examples{
pScreen=c(seq(1e-10,1e-2,length.out=100),seq(1e-2,.2,length.out=100),seq(.2,1,length.out=100))
names(pScreen)=paste0("gene",1:300)
pConfirmation=matrix(runif(900),nrow=300,ncol=3)
dimnames(pConfirmation)=list(paste0("gene",1:300),c("H1","H2","H3"))
stageRObj <- stageR(pScreen=pScreen, pConfirmation=pConfirmation)
stageRObj <- stageWiseAdjustment(stageRObj, method="holm", alpha=0.05)
head(getAdjustedPValues(stageRObj, onlySignificantGenes=TRUE, order=TRUE))
}
\references{
Van den Berge K., Soneson C., Robinson M.D., Clement L. (2017). stageR: a general stage-wise method for controlling the gene-level false discovery rate in differential expression and differential transcript usage. Genome Biology 18:151. https://doi.org/10.1186/s13059-017-1277-0
}
