% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Run_Loc_Match.R
\name{Run_Loc_Match}
\alias{Run_Loc_Match}
\title{Match spatial location After Pre-Processing for Sequencing-Based Spatial Transcriptomics}
\usage{
Run_Loc_Match(config, pixel = FALSE, show.config = TRUE)
}
\arguments{
\item{config}{Path to the YAML configuration file.}

\item{pixel}{Computing spot pixel or not. If yes, compute pixel for each spot and map back to image; if not, map the Visium coordination system. Defaults to FALSE.}

\item{show.config}{Logical value indicating whether to print the configuration. Defaults to TRUE.}
}
\value{
A data frame contains gene count matrix with spatial coordinates
}
\description{
This function matches spatial coordinates for sST data after upstream pre-processing.
'Run_loc_match' can either map the technology coordination system (such as spot in Visium coordination, bead in Slide-seq coordination)
or compute pixel for each spot and map the pixel information back to the image (only for Visium)
}
\examples{
data_dir <- tempdir()
output_dir <- file.path(tempdir(), "Run_Loc_Match_output")
if (!dir.exists(output_dir)) dir.create(output_dir, recursive = TRUE)
sample_index <- data.frame(
  barcode_sequence = c("BC001", "BC002", "BC003"),
  cell_name = c("CELL_1", "CELL_2", "CELL_3"),
  stringsAsFactors = FALSE
)
write.csv(sample_index, file = file.path(output_dir, "sample_index.csv"), row.names = FALSE)
gene_count <- data.frame(
  gene_id = c("gene1", "gene2"),
  CELL_1 = c(10, 5),
  CELL_2 = c(20, 10),
  CELL_3 = c(30, 15),
  stringsAsFactors = FALSE
)
write.csv(gene_count, file = file.path(output_dir, "gene_count.csv"), row.names = FALSE)
config_list <- list(
  output_directory = output_dir,
  data_directory = data_dir,
  technology_version = "Visium_probe_v1",
  visium_coordination = "V1"
)
config_file <- tempfile(fileext = ".yml")
yaml::write_yaml(config_list, config_file)
result <- Run_Loc_Match(
  config = config_file, 
  pixel = FALSE, 
  show.config = FALSE
)
}
