% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparseDC-simulate.R
\name{sparseDCSimulate}
\alias{sparseDCSimulate}
\title{SparseDC simulation}
\usage{
sparseDCSimulate(
  params = newSparseDCParams(),
  sparsify = TRUE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{params}{SparseDCParams object containing simulation parameters.}

\item{sparsify}{logical. Whether to automatically convert assays to sparse
matrices if there will be a size reduction.}

\item{verbose}{logical. Whether to print progress messages}

\item{...}{any additional parameter settings to override what is provided in
\code{params}.}
}
\value{
SingleCellExperiment containing simulated counts
}
\description{
Simulate counts from cluster in two conditions using the SparseDC method.
}
\details{
This function is just a wrapper around
\code{\link[SparseDC]{sim_data}} that takes a
\code{\link{SparseDCParams}}, runs the simulation then converts the
output from log-expression to counts and returns a
\code{\link[SingleCellExperiment]{SingleCellExperiment}} object. The original
simulated log-expression values are returned in the \code{LogExprs} assay.
See \code{\link[SparseDC]{sim_data}} and the SparseDC paper for
more details about how the simulation works.
}
\examples{
if (requireNamespace("SparseDC", quietly = TRUE)) {
    sim <- sparseDCSimulate()
}
}
\references{
Campbell K, Yau C. Uncovering genomic trajectories with heterogeneous genetic
and environmental backgrounds across single-cells and populations. bioRxiv
(2017).

Barron M, Zhang S, Li J. A sparse differential clustering algorithm for
tracing cell type changes via single-cell RNA-sequencing data.
Nucleic Acids Research (2017).

Paper: \url{10.1093/nar/gkx1113}
}
