% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pheno-simulate.R
\name{phenoSimulate}
\alias{phenoSimulate}
\title{PhenoPath simulation}
\usage{
phenoSimulate(params = newPhenoParams(), sparsify = TRUE, verbose = TRUE, ...)
}
\arguments{
\item{params}{PhenoParams object containing simulation parameters.}

\item{sparsify}{logical. Whether to automatically convert assays to sparse
matrices if there will be a size reduction.}

\item{verbose}{logical. Whether to print progress messages}

\item{...}{any additional parameter settings to override what is provided in
\code{params}.}
}
\value{
SingleCellExperiment containing simulated counts
}
\description{
Simulate counts from a pseudotime trajectory using the PhenoPath method.
}
\details{
This function is just a wrapper around
\code{\link[phenopath]{simulate_phenopath}} that takes a
\code{\link{PhenoParams}}, runs the simulation then converts the
output from log-expression to counts and returns a
\code{\link[SingleCellExperiment]{SingleCellExperiment}} object. The original
simulated log-expression values are returned in the \code{LogExprs} assay.
See \code{\link[phenopath]{simulate_phenopath}} and the PhenoPath paper for
more details about how the simulation works.
}
\examples{
if (requireNamespace("phenopath", quietly = TRUE)) {
    sim <- phenoSimulate()
}
}
\references{
Campbell K, Yau C. Uncovering genomic trajectories with heterogeneous genetic
and environmental backgrounds across single-cells and populations. bioRxiv
(2017).

Paper: \url{10.1101/159913}

Code: \url{https://github.com/kieranrcampbell/phenopath}
}
