% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mfa-simulate.R
\name{mfaSimulate}
\alias{mfaSimulate}
\title{MFA simulation}
\usage{
mfaSimulate(params = newMFAParams(), sparsify = TRUE, verbose = TRUE, ...)
}
\arguments{
\item{params}{MFAParams object containing simulation parameters.}

\item{sparsify}{logical. Whether to automatically convert assays to sparse
matrices if there will be a size reduction.}

\item{verbose}{Logical. Whether to print progress messages.}

\item{...}{any additional parameter settings to override what is provided in
\code{params}.}
}
\value{
SingleCellExperiment containing simulated counts
}
\description{
Simulate a bifurcating pseudotime path using the mfa method.
}
\details{
This function is just a wrapper around \code{\link[mfa]{create_synthetic}}
that takes a \code{\link{MFAParams}}, runs the simulation then converts the
output from log-expression to counts and returns a
\code{\link[SingleCellExperiment]{SingleCellExperiment}} object. See
\code{\link[mfa]{create_synthetic}} and the mfa paper for more details about
how the simulation works.
}
\examples{
if (requireNamespace("mfa", quietly = TRUE)) {
    sim <- mfaSimulate()
}
}
\references{
Campbell KR, Yau C. Probabilistic modeling of bifurcations in single-cell
gene expression data using a Bayesian mixture of factor analyzers. Wellcome
Open Research (2017).

Paper: \url{10.12688/wellcomeopenres.11087.1}

Code: \url{https://github.com/kieranrcampbell/mfa}
}
