% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lun2-estimate.R
\name{lun2Estimate}
\alias{lun2Estimate}
\alias{lun2Estimate.SingleCellExperiment}
\alias{lun2Estimate.matrix}
\title{Estimate Lun2 simulation parameters}
\usage{
lun2Estimate(
  counts,
  plates,
  params = newLun2Params(),
  min.size = 200,
  verbose = TRUE,
  BPPARAM = SerialParam()
)

\method{lun2Estimate}{SingleCellExperiment}(
  counts,
  plates,
  params = newLun2Params(),
  min.size = 200,
  verbose = TRUE,
  BPPARAM = SerialParam()
)

\method{lun2Estimate}{matrix}(
  counts,
  plates,
  params = newLun2Params(),
  min.size = 200,
  verbose = TRUE,
  BPPARAM = SerialParam()
)
}
\arguments{
\item{counts}{either a counts matrix or a SingleCellExperiment object
containing count data to estimate parameters from.}

\item{plates}{integer vector giving the plate that each cell originated from.}

\item{params}{Lun2Params object to store estimated values in.}

\item{min.size}{minimum size of clusters when identifying group of cells in
the data.}

\item{verbose}{logical. Whether to show progress messages.}

\item{BPPARAM}{A \code{\link[BiocParallel]{BiocParallelParam}} instance
giving the parallel back-end to be used. Default is
\code{\link[BiocParallel]{SerialParam}} which uses a single core.}
}
\value{
LunParams object containing the estimated parameters.
}
\description{
Estimate simulation parameters for the Lun2 simulation from a real dataset.
}
\details{
See \code{\link{Lun2Params}} for more details on the parameters.
}
\examples{
\donttest{
# Load example data
library(scuttle)
set.seed(1)
sce <- mockSCE()

plates <- as.numeric(factor(colData(sce)$Mutation_Status))
params <- lun2Estimate(sce, plates, min.size = 20)
params
}
}
