% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDiagnostics.R
\name{plotDiagnostics}
\alias{plotDiagnostics}
\title{Compute spillover probability and correct for spillover}
\usage{
plotDiagnostics(sce, ch)
}
\arguments{
\item{sce}{A \code{\link[SingleCellExperiment]{SingleCellExperiment}} object}

\item{ch}{Character string specifying the channel to plot}
}
\value{
A list of \code{\link[ggplot2]{ggplot2}} plots
}
\description{
Compute spillover probability and correct for spillover
}
\examples{
library(CATALYST)
library(dplyr)
bc_key <- c(139, 141:156, 158:176)
sce_bead <- prepData(ss_exp)
sce_bead <- assignPrelim(sce_bead, bc_key, verbose = FALSE)
sce_bead <- applyCutoffs(estCutoffs(sce_bead))
sce_bead <- computeSpillmat(sce_bead)
data(mp_cells, package = "CATALYST")
sce <- prepData(mp_cells)
marker_to_barc <- rowData(sce_bead)[, c("channel_name", "is_bc")] |>
    as_tibble() |>
    filter(is_bc == TRUE) |>
    mutate(barcode = bc_key) |>
    select(marker = channel_name, barcode)
sce <- spillR::compCytof(sce, sce_bead, marker_to_barc, impute_value = NA)
plotDiagnostics(sce, "Yb173Di")
}
