% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spike_counts.R
\name{spike_counts}
\alias{spike_counts}
\title{use the index of a spiked BAM/CRAM file for spike contig coverage}
\usage{
spike_counts(
  bam,
  spike,
  sep = "_",
  ref = "spike",
  verbose = FALSE,
  dump_idx = FALSE
)
}
\arguments{
\item{bam}{the BAM or CRAM file (MUST HAVE AN INDEX)}

\item{spike}{a data.frame, DataFrame, or similar with spikes}

\item{sep}{separator character in contig names ("_")}

\item{ref}{reference name for spike genome ("spike")}

\item{verbose}{be verbose? (FALSE)}

\item{dump_idx}{dump the renamed idxstats to aggregate? (FALSE)}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{               a GRanges of spike-in contig read counts
}\if{html}{\out{</div>}}
}
\description{
It dawned on me one day that we don't even have to bother reading the file
if we have an index for a spiked BAM/CRAM result, since any fragments that
map properly to the spike contigs are generated from synthetic templates.
This function takes an index and a spike database (usually a DataFrame) as
inputs and provides a rough coverage estimate over "rehabilitated" contig
names (i.e., canonicalized contigs mapping to the database) as its output.
}
\details{
The argument \code{spike} has no default since we are attempting to refactor the
spike-in databases into their own data packages and allow more general use.
}
\examples{
data(spike, package="spiky")
sb <- system.file("extdata", "example.spike.bam", package="spiky",
                  mustWork=TRUE) 
spike_counts(sb, spike=spike)

}
