% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmax.R
\name{kmax}
\alias{kmax}
\title{simple contig kmer comparisons}
\usage{
kmax(km, normalize = TRUE)
}
\arguments{
\item{km}{kmer summary}

\item{normalize}{normalize (divide by row sums)? (TRUE)}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{       the most common kmers for each contig, across all contigs
}\if{html}{\out{</div>}}
}
\description{
simple contig kmer comparisons
}
\examples{


data(genbank_mito, package="spiky")
mtk6 <- kmers(genbank_mito, k=6)
rownames(mtk6) <- paste0(rownames(mtk6), "_MT")
kmax(mtk6)

data(phage, package="spiky")
phk6 <- kmers(phage, k=6)
kmax(phk6, normalize=FALSE)

stopifnot(identical(colnames(phk6), colnames(mtk6)))
k6 <- rbind(mtk6, phk6)
kmax(k6)

}
