% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/spicy.R
\docType{class}
\name{SpicyResults-class}
\alias{SpicyResults-class}
\alias{SpicyResults,list,ANY-method}
\alias{spicy}
\alias{spicy,spicy-method}
\title{Performs spatial tests on spatial cytometry data.}
\usage{
spicy(
  cells,
  condition,
  subject = NULL,
  covariates = NULL,
  imageID = "imageID",
  cellType = "cellType",
  spatialCoords = c("x", "y"),
  r = NULL,
  sigma = NULL,
  from = NULL,
  to = NULL,
  alternateResult = NULL,
  cores = 1,
  minLambda = 0.05,
  weights = TRUE,
  weightsByPair = FALSE,
  weightFactor = 1,
  window = "convex",
  window.length = NULL,
  edgeCorrect = TRUE,
  includeZeroCells = FALSE,
  verbose = FALSE,
  BPPARAM = NULL,
  imageIDCol = imageID,
  cellTypeCol = cellType,
  spatialCoordCols = spatialCoords,
  nCores = cores,
  Rs = r,
  ...
)
}
\arguments{
\item{cells}{A SummarizedExperiment or data frame that contains at least the  variables
x and y, giving the location coordinates of each cell, and cellType.}

\item{condition}{A character specifying which column which contains the condition or `Surv` objects.}

\item{subject}{Vector of subject IDs corresponding to each image if cells is
a data frame.}

\item{covariates}{Vector of covariate names that should be included in the
mixed effects model as fixed effects.}

\item{imageID}{The name of the imageID column if using a SingleCellExperiment or SpatialExperiment.}

\item{cellType}{The name of the cellType column if using a SingleCellExperiment or SpatialExperiment.}

\item{spatialCoords}{The names of the spatialCoords column if using a SingleCellExperiment.}

\item{r}{A vector of the radii that the measures of association should be calculated over.}

\item{sigma}{A numeric variable used for scaling when fitting inhomogenous L-curves.}

\item{from}{vector of cell types which you would like to compare to the to vector.}

\item{to}{vector of cell types which you would like to compare to the from vector.}

\item{alternateResult}{A pairwise association statistic between each combination of celltypes in
each image.}

\item{cores}{Number of cores to use for parallel processing or a BiocParallel MulticoreParam or SerialParam object.}

\item{minLambda}{Minimum value density for scaling when fitting inhomogeneous L-curves.}

\item{weights}{logical indicating whether to include weights based on cell counts.}

\item{weightsByPair}{logical indicating whether weights should be calculated for each cell type
pair.}

\item{weightFactor}{numeric that controls the convexity of the weight function.}

\item{window}{Should the window around the regions be 'square', 'convex' or 'concave'.}

\item{window.length}{A tuning parameter for controlling the level of concavity when estimating concave windows.}

\item{edgeCorrect}{A logical indicating whether to perform edge correction.}

\item{includeZeroCells}{A logical indicating whether to include cells with zero counts in the pairwise association calculation.}

\item{verbose}{logical indicating whether to output messages.}

\item{BPPARAM}{\{DEPRECATED\} A BiocParallel MulticoreParam or SerialParam object.}

\item{imageIDCol}{\{DEPRECATED\} The name of the imageID column if using a SingleCellExperiment or SpatialExperiment.}

\item{cellTypeCol}{\{DEPRECATED\} The name of the cellType column if using a SingleCellExperiment or SpatialExperiment.}

\item{spatialCoordCols}{\{DEPRECATED\} The names of the spatialCoords column if using a SingleCellExperiment.}

\item{nCores}{\{DEPRECATED\} Number of cores to use for parallel processing or a BiocParallel MulticoreParam or SerialParam object.}

\item{Rs}{\{DEPRECATED\} A vector of the radii that the measures of association should be calculated over.}

\item{...}{Other options}
}
\value{
Data frame of p-values.
}
\description{
Performs spatial tests on spatial cytometry data.
}
\examples{
data("diabetesData")

# Test with random effect for patient on a pairwise combination of cell
# types.
spicy(diabetesData,
  condition = "stage", subject = "case",
  from = "Tc", to = "Th"
)

# Test all pairwise combinations of cell types without random effect of
# patient.
\dontrun{
spicyTest <- spicy(diabetesData, condition = "stage", subject = "case")
}

# Test all pairwise combination of cell types with random effect of patient.
\dontrun{
spicy(diabetesData, condition = "condition", subject = "subject")
}

}
