% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shm.R
\name{shm}
\alias{shm}
\alias{shm,SPHM-method}
\title{Plot Spatial Heatmaps}
\usage{
\S4method{shm}{SPHM}(
  data,
  assay.na = NULL,
  sam.factor = NULL,
  con.factor = NULL,
  ID,
  charcoal = FALSE,
  alpha.overlay = 1,
  lay.shm = "gene",
  ncol = 2,
  h = 0.99,
  col.com = c("yellow", "orange", "red"),
  col.bar = "selected",
  thr = c(NA, NA),
  cores = NA,
  bar.width = 0.08,
  bar.title = NULL,
  bar.title.size = 0,
  scale = "no",
  ft.trans = NULL,
  tis.trans = ft.trans,
  legend.r = 0.9,
  sub.title.size = 11,
  sub.title.vjust = 2,
  legend.plot = "all",
  ft.legend = "identical",
  bar.value.size = 10,
  legend.plot.title = "Legend",
  legend.plot.title.size = 11,
  legend.ncol = NULL,
  legend.nrow = NULL,
  legend.position = "bottom",
  legend.direction = NULL,
  legend.key.size = 0.02,
  legend.text.size = 12,
  angle.text.key = NULL,
  position.text.key = NULL,
  legend.2nd = FALSE,
  position.2nd = "bottom",
  legend.nrow.2nd = NULL,
  legend.ncol.2nd = NULL,
  legend.key.size.2nd = 0.03,
  legend.text.size.2nd = 10,
  angle.text.key.2nd = 0,
  position.text.key.2nd = "right",
  add.feature.2nd = FALSE,
  label = FALSE,
  label.size = 4,
  label.angle = 0,
  hjust = 0,
  vjust = 0,
  opacity = 1,
  key = TRUE,
  line.width = 0.2,
  image = NULL,
  line.color = "grey70",
  relative.scale = NULL,
  out.dir = NULL,
  animation.scale = 1,
  aspr = 1,
  selfcontained = FALSE,
  video.dim = "640x480",
  res = 500,
  interval = 1,
  framerate = 1,
  bar.width.vdo = 0.1,
  legend.value.vdo = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{data}{An `SHM` class that containing the numeric data and aSVG instances for plotting SHMs or co-visualization plots. See \code{\link{SPHM}}.}

\item{assay.na}{The name of target assay to use when \code{data} is \code{SummarizedExperiment}.}

\item{sam.factor}{The column name corresponding to spatial features in \code{colData} of \code{SummarizedExperiment}. If the column names in the \code{assay} slot already follows the scheme "spatialFeature__variable", then the \code{colData} slot is not required and accordingly this argument could be NULL.}

\item{con.factor}{The column name corresponding to experimental variables in \code{colData} of \code{SummarizedExperiment}. It can be NULL if column names of in the \code{assay} slot already follows the scheme "spatialFeature__variable", or no variable is associated with the data.}

\item{ID}{A character vector of assyed items (\emph{e.g.} genes, proteins) whose abudance values are used to color the aSVG.}

\item{charcoal}{Logical, if \code{TRUE} the raster image will be turned black and white.}

\item{alpha.overlay}{The opacity of the raster image under the SHM when superimposing raster images with SHMs. The default is 1.}

\item{lay.shm}{One of `gene`, `con`, or `none`. If `gene`, SHMs are organized horizontally by each biomolecule (gene, protein, or metabolite, \emph{etc.}) and variables are sorted under each biomolecule. If `con`, SHMs are organized horizontally by each experiment vairable and biomolecules are sorted under each variable. If `none`, SHMs are organized by the biomolecule order in \code{ID} and variables follow the order they appear in \code{data}.}

\item{ncol}{The number of columns to display SHMs, which does not include the legend plot.}

\item{h}{The height (0-1) of color key and SHM/co-visualization plots in the middle, not including legend plots.}

\item{col.com}{A vector of color components used to build the color scale. The default is `c('yellow', 'orange', 'red')`.}

\item{col.bar}{One of `selected` or `all`, the former uses expression values of \code{ID} to build the color scale while the latter uses all expression values from the data. The default is `selected`.}

\item{thr}{A two-numeric vector of expression value thresholds (the range of the color bar). The first and the second element will be the minmun and maximum threshold in the color bar respectively. Values above the max or below min will be assigned the same color as the max or min respectively. The default is \code{c(NA, NA)} and the min and max values in the data will be used. If one needs to change only max or min, the other should be \code{NA}.}

\item{cores}{The number of CPU cores for parallelization. The default is `NA`, and the number of used cores is 1 or 2 depending on the availability.}

\item{bar.width}{The width of color bar that ranges from 0 to 1. The default is 0.08.}

\item{bar.title, bar.title.size}{The title and title size of the color key.}

\item{scale}{One of \code{no} (default), \code{selected}, \code{all}, or \code{row}, corresponding to no scaling, scaling selected rows as a whole, scaling all rows as a whole, or scaling each row independently.}

\item{ft.trans}{A character vector of spatial features that will be set transparent. When features of interest are covered by overlapping features on the top layers and the latter can be set transparent.}

\item{tis.trans}{This argument is deprecated and replaced by \code{ft.trans}.}

\item{legend.r}{A numeric (-1 to 1) to adjust the legend plot size.}

\item{sub.title.size}{A numeric of the subtitle font size of each individual spatial heatmap. The default is 11.}

\item{sub.title.vjust}{A numeric of vertical adjustment for subtitle. The default is \code{2}.}

\item{legend.plot}{A vector of suffix(es) of aSVG file name(s) such as \code{c('shm1', 'shm2')}. Only aSVG(s) whose suffix(es) are assigned to this arugment will have a legend plot on the right. The default is \code{all} and each aSVG will have a legend plot. If NULL, no legend plot is shown.}

\item{ft.legend}{One of "identical", "all", or a character vector of tissue/spatial feature identifiers from the aSVG file. The default is "identical" and all the identical/matching tissues/spatial features between the data and aSVG file are colored in the legend plot. If "all", all tissues/spatial features in the aSVG are shown. If a vector, only the tissues/spatial features in the vector are shown.}

\item{bar.value.size}{A numeric of value size in the y-axis of the color bar. The default is 10.}

\item{legend.plot.title}{The title of the legend plot. The default is 'Legend'.}

\item{legend.plot.title.size}{The title size of the legend plot. The default is 11.}

\item{legend.ncol}{An integer of the total columns of keys in the legend plot. The default is NULL. If both \code{legend.ncol} and \code{legend.nrow} are used, the product of the two arguments should be equal or larger than the total number of shown spatial features.}

\item{legend.nrow}{An integer of the total rows of keys in the legend plot. The default is NULL. It is only applicable to the legend plot. If both \code{legend.ncol} and \code{legend.nrow} are used, the product of the two arguments should be equal or larger than the total number of matching spatial features.}

\item{legend.position}{the default position of legends ("none", "left",
"right", "bottom", "top", "inside")}

\item{legend.direction}{layout of items in legends ("horizontal" or
"vertical")}

\item{legend.key.size}{A numeric of the legend key size ("npc"), applicable to the legend plot. The default is 0.02.}

\item{legend.text.size}{A numeric of the legend label size, applicable to the legend plot. The default is 12.}

\item{angle.text.key}{Key text angle in legend plots. The default is NULL, equivalent to 0.}

\item{position.text.key}{The position of key text in legend plots, one of `top`, `right`, `bottom`, `left`. Default is NULL, equivalent to `right`.}

\item{legend.2nd}{Logical. If `TRUE`, the secondary legend is added to each SHM, which are the numeric values of each colored spatial features. The default its `FALSE`. Only applies to the static image.}

\item{position.2nd}{The position of the secondary legend in SHMs, one of `top`, `right`, `bottom`, `left`, or a two-component numeric vector. The default is `bottom`. Applies to images and videos.}

\item{legend.nrow.2nd}{An integer of rows of the secondary legend keys in SHMs. Applies to static images and videos.}

\item{legend.ncol.2nd}{An integer of columns of the secondary legend keys in SHMs. Applies to static images and videos.}

\item{legend.key.size.2nd}{A numeric of legend key size in SHMs. The default is 0.03. Applies to static images and videos.}

\item{legend.text.size.2nd}{A numeric of the secondary legend text size in SHMs. The default is 10. Applies to static images and videos.}

\item{angle.text.key.2nd}{Angle of the key text in the secondary legend in SHMs. Default is 0. Applies to static images and videos.}

\item{position.text.key.2nd}{The position of key text in the secondary legend in SHMs, one of `top`, `right`, `bottom`, `left`. Default is `right`. Applies to static images and videos.}

\item{add.feature.2nd}{Logical. If `TRUE`, feature identifiers are added to the secondary legend. The default is FALSE. Applies to static images of SHMs.}

\item{label}{Logical. If `TRUE`, the same spatial features between numeric data and aSVG are labeled by their identifiers. The default is `FALSE`. It is useful when spatial features are labeled by similar colors.}

\item{label.size}{The size of spatial feature labels in legend plots. The default is 4.}

\item{label.angle}{The angle of spatial feature labels in legend plots. Default is 0.}

\item{hjust, vjust}{The value to horizontally or vertically adjust positions of spatial feature labels in legend plots respectively. Default of both is 0.}

\item{opacity}{The transparency of colored spatial features in legend plots. Default is 1. If 0, features are totally transparent.}

\item{key}{Logical. If `TRUE` (default), keys are added in legend plots. If \code{label} is TRUE, the keys could be removed.}

\item{line.width}{The thickness of each shape outline in the aSVG is maintained in spatial heatmaps, \emph{i.e.} the stroke widths in Inkscape. This argument is the extra thickness added to all outlines. Default is 0.2 in case stroke widths in the aSVG are 0.}

\item{image}{Name of SpatialImage object to get coordinates for. If NULL (default), will retrieve coordinates for the default image. See \code{GetTissueCoordinates} in \code{SeuratObject} for details.}

\item{line.color}{A character of the shape outline color. Default is "grey70".}

\item{relative.scale}{A numeric to adjust the relative sizes between multiple aSVGs. Applicable only if multiple aSVGs are provided. Default is \code{NULL} and all aSVGs have the same size.}

\item{out.dir}{The directory to save SHMs as interactive HTML files and videos. Default is `NULL`, and the HTML files and videos are not saved.}

\item{animation.scale}{A numeric to scale the SHM size in the HTML files. The default is 1, and the height is 550px and the width is calculated according to the original aspect ratio in the aSVG file.}

\item{aspr}{The aspect ratio (width to height) in the interative HTML files.}

\item{selfcontained}{Whether to save the HTML as a single self-contained file
(with external resources base64 encoded) or a file with external resources
placed in an adjacent directory.}

\item{video.dim}{A single character of the dimension of video frame in form of 'widthxheight', such as '1920x1080', '1280x800', '320x568', '1280x1024', '1280x720', '320x480', '480x360', '600x600', '800x600', '640x480' (default). The aspect ratio of SHMs are decided by \code{width} and \code{height}.}

\item{res}{Resolution of the video in dpi.}

\item{interval}{The time interval (seconds) between SHM frames in the video. Default is 1.}

\item{framerate}{An integer of video framerate in frames per seconds. Default is 1. Larger values make the video smoother.}

\item{bar.width.vdo}{The color bar width (0-1) in videos.}

\item{legend.value.vdo}{Logical. If `TRUE`, numeric values of colored spatial features are added to the video legend. The default is NULL.}

\item{verbose}{Logical. If `TRUE` (default), intermediate messages will be printed.}

\item{...}{additional element specifications not part of base ggplot2. In general,
these should also be defined in the \verb{element tree} argument. \link[rlang:splice]{Splicing} a list is also supported.}
}
\value{
An `SPHM` object.
}
\description{
The input are a pair of annotated SVG (aSVG) file and formatted numeric data (\code{vector}, \code{data.frame}, \code{SummarizedExperiment}). In the aSVG, spatial features (tissues, organs, etc) are represented by shapes and assigned unique identifiers, and the numeric data are measured from these spatial features. In biological applications, aSVGs are anatomical structures, and numeric data are expression values of genes, proteins, metabolites, etc assayed from spatial features. Numeric data are mapped to spatial features in aSVGs according to the same identifiers between the two. The mapped features are filled with colors translated from the numeric data while other features are transparent. The output images are termed spatial heatmaps (SHMs). 

This function is designed multi-functional for maximal flexibility. For example, SHMs can be organized horizontally by each gene or each experimental variable to facilitate comparisons. In multi-layer anotomical structures, selected tissues can be set transparent to expose burried features in lower layers. The color scale is customizable to highlight difference across features. This function also works with many other types of spatial data, such as population data plotted to geographic maps.
}
\section{Details}{

See the package vignette (\code{browseVignettes('spatialHeatmap')}).
}

\examples{

## The example data included in this package come from an RNA-seq analysis on 
## development of 7 chicken organs under 9 time points (Cardoso-Moreira et al. 2019). 
## The complete raw count data are downloaded using the R package ExpressionAtlas
## (Keays 2019) with the accession number "E-MTAB-6769". 

# Access example count data. 
count.chk <- read.table(system.file('extdata/shinyApp/data/count_chicken.txt', 
package='spatialHeatmap'), header=TRUE, row.names=1, sep='\t')
count.chk[1:3, 1:5]

# A targets file describing spatial features and variables is made based on the 
# experiment design.
target.chk <- read.table(system.file('extdata/shinyApp/data/target_chicken.txt', 
package='spatialHeatmap'), header=TRUE, row.names=1, sep='\t')
# Every column in example data 2 corresponds with a row in the targets file. 
target.chk[1:5, ]
# Store example data in "SummarizedExperiment".
library(SummarizedExperiment)
se.chk <- SummarizedExperiment(assay=count.chk, colData=target.chk)

# Normalize data.
se.chk.nor <- norm_data(data=se.chk, norm.fun='CNF', log2.trans=TRUE)

# Aggregate replicates of "spatialFeature_variable", where spatial features are organs
# and variables are ages.
se.chk.aggr <- aggr_rep(data=se.chk.nor, sam.factor='organism_part', con.factor='age',
aggr='mean')
assay(se.chk.aggr)[1:3, 1:3]

# Genes with experssion values >= 5 in at least 1\% of all samples (pOA), and coefficient
# of variance (CV) between 0.2 and 100 are retained.
se.chk.fil <- filter_data(data=se.chk.aggr, sam.factor='organism_part', con.factor='age', 
pOA=c(0.01, 5), CV=c(0.2, 100), file=NULL)

# The chicken aSVG downloaded from the EBI aSVG repository (https://github.com/ebi-gene-
# expression-group/anatomogram/tree/master/src/svg) is included in this package and 
# accessed as below.
svg.chk <- system.file("extdata/shinyApp/data", "gallus_gallus.svg",
package="spatialHeatmap")
# Read the chicken aSVG file.
svg.chk <- read_svg(svg.path=svg.chk)

# Store assay data and aSVG in an "SHM" class.
dat.chk <- SPHM(svg=svg.chk, bulk=se.chk.fil)
# Plot spatial heatmaps with gene "ENSGALG00000019846".
shm(data=dat.chk, ID='ENSGALG00000019846', legend.r=1.9,
legend.nrow=5, sub.title.size=7, ncol=3)

# Save SHMs as HTML and video files in the "~/test" directory. 
\donttest{
if (!dir.exists('~/test')) dir.create('~/test')
shm(data=dat.chk, ID='ENSGALG00000019846', legend.r=1.9,
legend.nrow=5, sub.title.size=7, ncol=3, out.dir='~/test')
}

}
\references{
https://www.gimp.org/tutorials/
https://inkscape.org/en/doc/tutorials/advanced/tutorial-advanced.en.html
http://www.microugly.com/inkscape-quickguide/
Martin Morgan, Valerie Obenchain, Jim Hester and Hervé Pagès (2018). SummarizedExperiment: SummarizedExperiment container. R package version 1.10.1
H. Wickham. ggplot2: Elegant Graphics for Data Analysis. Springer-Verlag New York, 2016.
Jeroen Ooms (2018). rsvg: Render SVG Images into PDF, PNG, PostScript, or Bitmap Arrays. R package version 1.3. https://CRAN.R-project.org/package=rsvg
R. Gentleman, V. Carey, W. Huber and F. Hahne (2017). genefilter: genefilter: methods for filtering genes from high-throughput experiments. R package version 1.58.1
Paul Murrell (2009). Importing Vector Graphics: The grImport Package for R. Journal of Statistical Software, 30(4), 1-37. URL http://www.jstatsoft.org/v30/i04/ 
Baptiste Auguie (2017). gridExtra: Miscellaneous Functions for "Grid" Graphics. R package version 2.3. https://CRAN.R-project.org/package=gridExtra
R Core Team (2018). R: A language and environment for statistical computing. R Foundation for Statistical Computing, Vienna, Austria. RL https://www.R-project.org/
https://github.com/ebi-gene-expression-group/anatomogram/tree/master/src/svg 
Yu, G., 2020. ggplotify:  Convert Plot to ’grob’ or ’ggplot’ Object. R package version 0.0.5.URLhttps://CRAN.R-project.org/package=ggplotify30
Keays, Maria. 2019. ExpressionAtlas: Download Datasets from EMBL-EBI Expression Atlas
Love, Michael I., Wolfgang Huber, and Simon Anders. 2014. "Moderated Estimation of Fold Change and Dispersion for RNA-Seq Data with DESeq2." Genome Biology 15 (12): 550. doi:10.1186/s13059-014-0550-8
Guangchuang Yu (2020). ggplotify: Convert Plot to 'grob' or 'ggplot' Object. R package version 0.0.5. https://CRAN.R-project.org/package=ggplotify
Cardoso-Moreira, Margarida, Jean Halbert, Delphine Valloton, Britta Velten, Chunyan Chen, Yi Shao, Angélica Liechti, et al. 2019. “Gene Expression Across Mammalian Organ Development.” Nature 571 (7766): 505–9
Marques A et al. (2016). Oligodendrocyte heterogeneity in the mouse juvenile and adult central nervous system. Science 352(6291), 1326-1329.
Amezquita R, Lun A, Becht E, Carey V, Carpp L, Geistlinger L, Marini F, Rue-Albrecht K, Risso D, Soneson C, Waldron L, Pages H, Smith M, Huber W, Morgan M, Gottardo R, Hicks S (2020). “Orchestrating single-cell analysis with Bioconductor.” Nature Methods, 17, 137–145. https://www.nature.com/articles/s41592-019-0654-x.
Vacher, Claire-Marie, Helene Lacaille, Jiaqi J O’Reilly, Jacquelyn Salzbank, Dana Bakalar, Sonia Sebaoui, Philippe Liere, et al. 2021. “Placental Endocrine Function Shapes Cerebellar Development and Social Behavior.” Nat. Neurosci. 24 (10). Nature Publishing Group: 1392–1401
}
\author{
Jianhai Zhang \email{jzhan067@ucr.edu} \cr Dr. Thomas Girke \email{thomas.girke@ucr.edu}
}
