% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cut_dendro.R
\name{cut_dendro}
\alias{cut_dendro}
\title{Cutting dendrograms}
\usage{
cut_dendro(dendro, h, target)
}
\arguments{
\item{dendro}{A dendrogram from heirarchical clustering.}

\item{h}{A numeric of height for cutting the dendrogram.}

\item{target}{The target biomoleclue.}
}
\value{
A vector of the cluster containing the query biomolecule.
}
\description{
This function is designed to cut dendrograms from heirarchical clustering at a certain height and returns the cluster containing the query biomolecule.
}
\examples{
blk.mus.pa <- system.file("extdata/shinyApp/data", "bulk_mouse_cocluster.rds", package="spatialHeatmap") 
blk.mus <- readRDS(blk.mus.pa)
res.hc <- matrix_hm(ID=c('Actr3b'), data=blk.mus, angleCol=60, angleRow=60, cexRow=0.8, cexCol=0.8, 
margin=c(10, 6), static=TRUE, arg.lis1=list(offsetRow=0.01, offsetCol=0.01))
cut_dendro(res.hc$rowDendrogram, h=1000, 'Actr3b')
}
\references{
Tal Galili (2015). dendextend: an R package for visualizing, adjusting, and comparing trees of hierarchical clustering. Bioinformatics. DOI: 10.1093/bioinformatics/btv428
}
\author{
Jianhai Zhang \email{jzhan067@ucr.edu} \cr Dr. Thomas Girke \email{thomas.girke@ucr.edu}
}
