% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMetric.R
\name{plotFbPlot}
\alias{plotFbPlot}
\title{Functional boxplot of spatstat curves}
\usage{
plotFbPlot(metricDf, x, y, aggregateBy)
}
\arguments{
\item{metricDf}{the metric dataframe as calculated by \code{calcMetricPerFov}}

\item{x}{the name of the x-axis of the spatial metric}

\item{y}{the name of the y-axis of the spatial metric}

\item{aggregateBy}{the criterion by which to aggregate the curves into a
functional boxplot. Can be e.g. the condition of the different samples.}
}
\value{
a list of base R plots
}
\description{
This function creates a functional boxplot of the spatial statistics curves.
It creates one functional boxplot per aggregation category, e.g. condition.
}
\examples{
# retrieve example data from Damond et al. (2019)
spe <- .loadExample()
metricRes <- calcMetricPerFov(spe, c("alpha", "Tc"),
    subsetby = "image_number", fun = "Gcross", marks = "cell_type",
    rSeq = seq(0, 50, length.out = 50), by = c(
        "patient_stage", "patient_id",
        "image_number"
    ),
    ncores = 1
)
# create a unique ID for the data preparation
metricRes$ID <- paste0(
  metricRes$patient_stage, "|", metricRes$patient_id,
  "|", metricRes$image_number
)

plotFbPlot(metricRes, 'r', 'rs', 'patient_stage')
}
