% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funcPca.R
\name{print.fpca}
\alias{print.fpca}
\title{print the fPCA results}
\usage{
\method{print}{fpca}(x, ...)
}
\arguments{
\item{x}{the result of function \code{functionalPCA}}

\item{...}{other parameters passed to base generic function \code{print}}
}
\value{
a formatted overview of the fPCA result
}
\description{
this is a function that prints a summary of the fPCA result of class \code{fpca}
}
\examples{
# load the pancreas dataset
library("tidyr")
library("stringr")
library("dplyr")
# retrieve example data from Damond et al. (2019)
spe <- .loadExample()
# calculate the Gcross metric for alpha and beta cells
metricRes <- calcMetricPerFov(spe, c("alpha", "beta"),
    subsetby = "image_number", fun = "Gcross",
    marks = "cell_type", rSeq = seq(0, 50, length.out = 50),
    c("patient_stage", "patient_id", "image_number"), ncores = 1
)
metricRes$ID <- paste0(
  metricRes$patient_stage, "|", metricRes$patient_id,
  "|", metricRes$image_number
)
# prepare data for FDA
dat <- prepData(metricRes, "r", "rs")

# drop rows with NA
dat <- dat |> drop_na()

# create meta info of the IDs
splitData <- strsplit(dat$ID, "|", fixed = TRUE)
dat$condition <- factor(sapply(splitData, function(x) x[1]))
dat$patient_id <- factor(sapply(splitData, function(x) x[2]))
dat$image_id <- factor(sapply(splitData, function(x) x[3]))
# calculate fPCA
mdl <- functionalPCA(
    data = dat, r = metricRes$r |> unique()
)
mdl
}
