% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funcPca.R
\name{functionalPCA}
\alias{functionalPCA}
\title{Functional Principal Component Analysis}
\usage{
functionalPCA(data, r, ...)
}
\arguments{
\item{data}{a data object for functional data analysis containing at least
the functional response $Y$.}

\item{r}{the functional domain}

\item{...}{Other parameters passed to \code{fpca.sc} functions}
}
\value{
a list with components of fpca.sc
}
\description{
A function that takes as input the output of \code{calcMetricPerFov} which has to
be converted into the correct format by \code{prepData}. The output is a list with
the \code{fpca.face} output from refund.
}
\examples{
# load the pancreas dataset
library("tidyr")
library("stringr")
library("dplyr")
# retrieve example data from Damond et al. (2019)
spe <- .loadExample()
# calculate the Gcross metric for alpha and Tc cells
metricRes <- calcMetricPerFov(spe, c("alpha", "Tc"),
    subsetby = "image_number", fun = "Gcross",
    marks = "cell_type", rSeq = seq(0, 50, length.out = 50),
    c("patient_stage", "patient_id", "image_number"), ncores = 1
)
metricRes$ID <- paste0(
  metricRes$patient_stage, "|", metricRes$patient_id,
  "|", metricRes$image_number
)
# prepare data for FDA
dat <- prepData(metricRes, "r", "rs")

# drop rows with NA
dat <- dat |> drop_na()
# create meta info of the IDs
splitData <- str_split(dat$ID, "x")
dat$condition <- factor(sapply(splitData, function(x) x[1]))
dat$patient_id <- factor(sapply(splitData, function(x) x[2]))
dat$image_id <- factor(sapply(splitData, function(x) x[3]))
# calculate fPCA
mdl <- functionalPCA(
    data = dat, r = metricRes$r |> unique()
)
}
