% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossSpatialInference.R
\name{crossSpatialInference}
\alias{crossSpatialInference}
\title{Function for Cross Spatial Inference}
\usage{
crossSpatialInference(
  spe,
  selection = NULL,
  fun,
  marks = NULL,
  rSeq = NULL,
  correction,
  sample_id,
  image_id,
  condition,
  continuous = FALSE,
  assay = "exprs",
  transformation = NULL,
  eps = NULL,
  delta = 0,
  family = stats::gaussian(link = "log"),
  verbose = TRUE,
  ncores = 1,
  ...
)
}
\arguments{
\item{spe}{a \code{SpatialExperiment} object}

\item{selection}{the mark(s) you want to compare. NOTE: This is directional.
c(A,B) is not the same result as c(B,A).}

\item{fun}{the \code{spatstat} function to compute on the point pattern object}

\item{marks}{the marks to consider e.g. cell types}

\item{rSeq}{the range of r values to compute the function over}

\item{correction}{the edge correction to be applied}

\item{sample_id}{the spe \code{colData} variable to mark the sample, if not NULL
this will result in a mixed model estimation}

\item{image_id}{the spe \code{colData} variable to mark the image}

\item{condition}{the spe \code{colData} variable to mark the condition}

\item{continuous}{A boolean indicating whether the marks are continuous
defaults to FALSE}

\item{assay}{the assay which is used if \code{continuous = TRUE}}

\item{transformation}{the transformation to be applied as exponential e.g. 1/2 for sqrt}

\item{eps}{some distributional families fail if the response is zero,
therefore, zeros can be replaced with a very small value eps}

\item{delta}{the delta value to remove from the beginning of the spatial
statistics functions. Can be reasonable if e.g. cells are always spaced
by 10 µm. If set to "minNnDist" it will take the mean of the minimum nearest
neighbour distance across all images for this cell type pair.}

\item{family}{the distributional family for the functional GAM}

\item{verbose}{logical indicating whether to print all information or not}

\item{ncores}{the number of cores to use for parallel processing, default = 1}

\item{...}{Other parameters passed to \code{spatstat.explore} functions for
parameters concerning the spatial function calculation and to \code{refund::pffr}
for the functional additive mixed model inference}
}
\value{
a list of objects created by the function \code{spatialInference}
with three objects: i) the dataframe with the spatial
statistics results, ii) the designmatrix of the inference and iii) the
fitted pffr object
}
\description{
This function is a wrappere function around \code{spatialInference}. It calculates
\code{spatialInference} results either for all cell types in \code{marks}
(if \code{selection == NULL}) or for a custom subset defined in \code{selection}.
}
\examples{
spe <- .loadExample()
#make the condition a factor variable
colData(spe)[["patient_stage"]] <- factor(colData(spe)[["patient_stage"]])
#relevel to have non-diabetic as the reference category
colData(spe)[["patient_stage"]] <- relevel(colData(spe)[["patient_stage"]],
"Non-diabetic")

selection <- c("acinar", "ductal")
resLs <- crossSpatialInference(spe, selection, fun = "Gcross",
                      marks = "cell_type", rSeq = seq(0, 50, length.out = 50),
                      correction = "rs", sample_id = "patient_id",
                      image_id = "image_number", condition = "patient_stage",
                      algorithm = "bam",
                      ncores = 1
                  )

}
