% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classify_SVGs.R
\name{spatial_patterns}
\alias{spatial_patterns}
\title{Group spatially variable genes into spatial patterns using automatic
expression histology (AEH)}
\usage{
spatial_patterns(
  x,
  coordinates,
  de_results,
  qval_thresh = 0.05,
  n_patterns,
  length,
  verbose = FALSE
)
}
\arguments{
\item{x}{\code{matrix}-like object of normalized counts. E.g. resulting from
\code{\link[=regress_out]{regress_out()}}.}

\item{coordinates}{\code{data.frame} with sample coordinates.
Each row is a sample, the columns with coordinates must be named 'x' and 'y'.}

\item{de_results}{\code{data.frame} resulting from \code{\link[=run]{run()}}.}

\item{qval_thresh}{\code{numeric} scalar, specifying the q-value significance
threshold to filter \code{de_results}. Only rows in \code{de_results} with
\code{qval < qval_thresh} will be kept. To disable, set \code{qval_thresh = NULL}.}

\item{n_patterns}{\code{integer} The number of spatial patterns}

\item{length}{\code{numeric} The characteristic length scale of the clusters}

\item{verbose}{\code{logical} controlling the display of the progress bar.}
}
\value{
\code{list} of two dataframe (pattern_results, patterns):
\code{pattern_results} dataframe with pattern membership information for each
gene.
\code{patterns} the posterior mean underlying expression fro genes in given
spatial patterns.
}
\description{
Group spatially variable genes into spatial patterns using automatic
expression histology (AEH)
}
\examples{
## Mock up a SpatialExperiment object wit 400 cells and 3 genes
set.seed(42)
mock <- mockSVG(size = 20, tot_genes = 3, de_genes = 1)

stabilized <- stabilize(mock$counts)
sample_info <- mock$coordinates
sample_info$total_counts <- colSums(mock$counts)
regressed <- regress_out(counts = stabilized, sample_info = sample_info)

## Run SpatialDE
de_results <- run(x = regressed, coordinates = mock$coordinates)

## Run Spatial_patterns
sp <- spatial_patterns(
    x = regressed,
    coordinates = mock$coordinates,
    de_results = de_results,
    qval_thresh = NULL,
    n_patterns = 5, length = 1.5
)

sp$pattern_results
sp$patterns

}
\references{
Svensson, V., Teichmann, S. & Stegle, O.
SpatialDE: identification of spatially variable genes.
Nat Methods 15, 343–346 (2018). \url{https://doi.org/10.1038/nmeth.4636}
}
