% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/renameRows.R
\name{renameRows}
\alias{renameRows}
\title{Smartly/easily rename the rows of an object.}
\usage{
renameRows(x, xref, duplicate.policy = "original", ...)
}
\arguments{
\item{x}{an object to whose rows need renaming}

\item{xref}{an object to help with the renaming.
\itemize{
\item A character vector where length(xref) == nrow(x). Every row in
x should correspond to the renamed value in the same position in
xref
\item If x is a DGEList, SummarizedExperiment, etc. this can be a string.
In this case, the string must name a column in the data container's
fData-like data.frame. The values in that column will be the new
candidate rownames for the object.
\item A two column data.frame. The first column has entries in rownames(x),
and the second column is the value to rename it to.
}}

\item{duplicate.policy}{The policy used to deal with duplicates in the
renamed values. If Multiple elements in the source can be renamed to
the same elements in the target (think of microarray probes to gene
symbols), what to do? By deafult (\code{"original"}), one of the original
elements will be renamed to the new name, and the rest will keep their
original (unique) names. When set to \code{"make.unique"}, the new name
will be kept, but \verb{*.1}, \verb{*.2}, etc. will be appended to all but the
first multimapper.}

\item{...}{pass through variable down to default method}
}
\value{
An updated version of \code{x} with freshly minted rownames.
}
\description{
The most common usecase for this is when you have a SummarizedExperiment,
DGEList, matrix, etc. that is "rownamed" by some gene idnetifiers (ensembl,
entrez, etc) that you want to "easily" convert to be rownamed by symbols.
And perhaps the most common use-case for this, again, would be able to
easily change rownames of a heatmap to symbols.
}
\details{
The rownames that can't successfully remapped will keep their old names.
This function should also guarantee that the rows of the incoming matrix
are the same as the outgoing one.
}
\examples{
eset <- exampleExpressionSet(do.voom = FALSE)
ess <- renameRows(eset, "symbol")

vm <- exampleExpressionSet(do.voom = TRUE)
vms <- renameRows(vm, "symbol")
}
