% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-msigdb.R
\name{getMSigCollection}
\alias{getMSigCollection}
\alias{getMSigGeneSetDb}
\title{Fetches gene set collections from the moleular signature database (MSigDB)}
\usage{
getMSigCollection(
  collection = NULL,
  species = "human",
  id.type = c("ensembl", "entrez", "symbol", "uniprot"),
  with.kegg = FALSE,
  promote.subcollection = FALSE,
  prefix.collection = FALSE,
  strip.subcollection.prefix = TRUE,
  merge.human.into.mouse = TRUE,
  ...
)

getMSigGeneSetDb(
  collection = NULL,
  species = "human",
  id.type = c("ensembl", "entrez", "symbol", "uniprot"),
  with.kegg = FALSE,
  promote.subcollection = FALSE,
  prefix.collection = FALSE,
  strip.subcollection.prefix = TRUE,
  merge.human.into.mouse = TRUE,
  refetch = FALSE,
  ...
)
}
\arguments{
\item{collection}{character vector specifying the collections you want
(c1, c2, ..., c7, h). By default we load just the hallmark collecitons.
Setting this to \code{NULL} loads all collections. Alternative you can also
include named subsets of collections, like \code{"reactome"}. Refer to the
Details section for more information.}

\item{species}{\code{"human"} or \code{"mouse"}? Really, this is anything available
in the \code{alias} column of the \code{sparrow:::species_info()} table (except
cyno).}

\item{id.type}{do you want the feature id's used in the gene sets to be
\code{"ensembl"} (default), \code{"entrez"}, or \code{"symbol"}.}

\item{with.kegg}{The Broad distributes the latest versions of the KEGG
genesets as part of the c2 collection. These genesets come with a
restricted license, so by default we do not return them as part of the
GeneSetDb. To include the KEGG gene sets when asking for the c2
collection, set this flag to \code{TRUE}.}

\item{promote.subcollection}{there are different sources of
genesets for a number of the collections in MSigDB. These are included
in the \code{gs_subcollection} column of \code{geneSets(this)}. When this is set to
\code{TRUE}, the collection column for the genesets is appended with the
subcollection.
So, instead of having a massive \code{"C2"} collection, you'll have bunch of
collections like \code{"C2_CGP"}, \code{"C2_CP:BIOCARTA"}, etc.}

\item{prefix.collection}{When \code{TRUE} (default: \code{FALSE}), the \code{"C1"}, \code{"C2"},
etc. is prefixed with \code{"MSigDB_*"}}

\item{strip.subcollection.prefix}{removes the CGP: type prefixes for the
\code{gs_subcollection} column, except for the C5 GO collection.}

\item{merge.human.into.mouse}{When \code{TRUE} (default), the OG human collections
are merged into the newly  minted (as of 2024) M* mouse collections. Set
to \code{FALSE} to not do that.}

\item{...}{pass through parameters}

\item{refetch}{If \code{TRUE}, this function will requiry the msigdbr package to
fetch genesets it has already retrieved and converted. When \code{FALSE},
the cached version of the genesets will be returned.}
}
\value{
a \code{BiocSet} of the MSigDB collections
}
\description{
This provides versioned genesets from gene set collections defined in
\href{http://software.broadinstitute.org/gsea/msigdb}{MSigDB}. Collections can
be retrieved by their collection name, ie \code{c("H", "C2", "C7")}.
}
\section{Functions}{
\itemize{
\item \code{getMSigGeneSetDb()}: retrieval method for a GeneSetDb container

}}
\section{Species and Identifier types}{

This function utilizes the functionality from the \code{{msigdbr}} and
\code{{babelgene}} packages to retrieve gene set definitions from a variety of
organisms and identifier types.
}

\section{KEGG Gene Sets}{

Due to the licensing restrictions over the KEGG collections, they are not
returned from this function unless they are explicitly asked for. You can
ask for them through this function by either (i) querying for the \code{"c2"}
collection while setting \code{with.kegg = TRUE}; or (ii) explicitly calling with
\code{collection = "kegg"}.
}

\section{Citing the Molecular Signatures Database}{

To cite your use of the Molecular Signatures Database (MSigDB), please
reference Subramanian, Tamayo, et al. (2005, PNAS 102, 15545-15550) and one
or more of the following as appropriate:
\itemize{
\item Liberzon, et al. (2011, Bionformatics);
\item Liberzon, et al. (2015, Cell Systems); and
\item The source for the gene set as listed on the gene set page.
}
}

\examples{
\donttest{
  # these take a while to load initially, so put them in dontrun blocks.
  # you should run these interactively to understand what they return
  bcs <- getMSigCollection("h", "human", "entrez")
  bcs.h.entrez <- getMSigCollection(c("h", "c2"), "human", "entrez")
  bcs.h.ens <- getMSigCollection(c("h", "c2"), "human", "ensembl")
  bcs.m.entrez <- getMSigCollection(c("h", "c2"), "mouse", "entrez")

  gdb <- getMSigGeneSetDb("h", "human", "entrez")
}
}
