% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testing-helpers.R
\name{exampleExpressionSet}
\alias{exampleExpressionSet}
\alias{exampleGeneSets}
\alias{exampleGeneSetDb}
\alias{exampleBiocSet}
\alias{exampleGeneSetDF}
\alias{exampleSparrowResult}
\alias{exampleDgeResult}
\title{Functions that load data for use in examples and testing.}
\usage{
exampleExpressionSet(
  dataset = c("tumor-vs-normal", "tumor-subtype"),
  do.voom = TRUE
)

exampleGeneSets(x, unlist = !missing(x))

exampleGeneSetDb()

exampleBiocSet()

exampleGeneSetDF()

exampleSparrowResult(cached = TRUE, methods = c("cameraPR", "fry"))

exampleDgeResult(
  species = "human",
  id.type = c("entrez", "ensembl"),
  induce.bias = NULL
)
}
\arguments{
\item{dataset}{Character vector indicating what samples wanted, either
\code{"tumor-vs-normal"} for a tumor vs normal dataset from TCGA, or
just the tumor samples from the same annotated with subtype.}

\item{do.voom}{If TRUE, a voomed EList is returned, otherwise an
ExpressionSet of counts.}

\item{x}{If provided, an expression/matrix object so that the genesets are
returned as (integer) index vectors into the rows of x whose rownames
match the ids in the geneset.}

\item{unlist}{return the genesets as nested list of lists (default: \code{TRUE}).
The top level lists corresponds to the collection, and the lists within
each are the inidividual gene sets. If \code{FALSE}, a single list of genesets
is returned.}

\item{cached}{If \code{TRUE} (default), returns a pre-saved SparrowResult object.
Otherwise calculates a fresh one using the \code{methods} provided}

\item{methods}{the methods to use to create a new SparrowResult for.}

\item{species}{the species to return the example result from (right now,
only "human")}

\item{id.type}{the type of identifiers to use: \code{"entrez"} (default) or
\code{"ensembl"}.}

\item{induce.bias}{We can simulate a bias on the pvalue by the gene's
\code{"effective_length"} or \code{"AveExpr"}. These are columns that are included
in the output. If \code{NULL}, no bias is introduced into the result.}
}
\value{
A list of lists of entrezIDs when \code{as == 'lol'}, or
a list of integers into the rows of \code{x}.
}
\description{
We provide examplar expression data (counts or voomed) as well as exemplar
gene sets in different forms.
}
\section{exampleExpressionSet}{

The expression data is a subset of the TCGA BRCA indication. Calling
\code{exampleExpressionSet(do.voom = TRUE)} will return a voomed \code{EList} version
of the data. When \code{do.voom = FALSE}, you will get a DGEList of the counts
}

\section{exampleGeneSets}{

Returns gene sets as either a list of feature identifiers. Entrez identifiers
are used. If \code{x} is provided, integers that index into the expression
container \code{x} are used (this is a legacy feature that we should nuke).
}

\section{exampleGeneSetDb}{

Returns gene sets as a \code{GeneSetDb} object
}

\section{exampleBiocSet}{

Returns gene sets as a \code{BiocSet} object
}

\section{exampleGeneSetDF}{

Returns a data.frame of gene set definitions. A data.frame of this form
can be passed into the \code{GeneSetDb()} contructor.
}

\examples{
vm <- exampleExpressionSet()
head(exampleGeneSets())
}
