% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_RCTD.R
\name{filterPixelsAndGetVars}
\alias{filterPixelsAndGetVars}
\title{Filter pixels and create internal variables}
\usage{
filterPixelsAndGetVars(
  spatial_experiment,
  spatial_counts,
  cell_type_info,
  gene_cutoff = 0.000125,
  fc_cutoff = 0.5,
  gene_cutoff_reg = 2e-04,
  fc_cutoff_reg = 0.75,
  gene_obs_min = 3,
  pixel_count_min = 10,
  UMI_min = 100,
  UMI_max = 2e+07,
  UMI_min_sigma = 300,
  class_df = NULL
)
}
\arguments{
\item{spatial_experiment}{\code{\link[SummarizedExperiment]{SummarizedExperiment}} object with
spatial transcriptomics data}

\item{spatial_counts}{spatial transcriptomics count matrix}

\item{cell_type_info}{list containing cell type information}

\item{gene_cutoff}{numeric, minimum normalized gene expression for genes to
be included in the platform effect normalization step (default: 0.000125)}

\item{fc_cutoff}{numeric, minimum log fold change (across cell types) for
genes to be included in the platform effect normalization step (default:
0.5)}

\item{gene_cutoff_reg}{numeric, minimum normalized gene expression for genes
to be included in the RCTD step (default: 0.0002)}

\item{fc_cutoff_reg}{numeric, minimum log fold change (across cell types) for
genes to be included in the RCTD step (default: 0.75)}

\item{gene_obs_min}{numeric, minimum number of times a gene must appear in
the spatial transcriptomics data to be included in the analysis
(default: 3)}

\item{pixel_count_min}{numeric, minimum total gene count for a pixel to be
included in the analysis (default: 10)}

\item{UMI_min}{numeric, minimum UMI count per pixel (default: 100)}

\item{UMI_max}{numeric, maximum UMI count per pixel (default: 20,000,000)}

\item{UMI_min_sigma}{numeric, minimum UMI count for pixels used in platform
effect normalization (default: 300)}

\item{class_df}{data frame mapping cell types to classes, optional. If
specified, RCTD will report confidence on the class level.}
}
\value{
List containing the filtered pixels and internal variables
}
\description{
Filter pixels and create internal variables
}
\keyword{internal}
